#!/bin/sh

########################################################################
#             (c) Copyright 2003 Lexmark International, Inc.           #
#                        All rights reserved                           #
########################################################################
#                                                                       
# This command is used to check file permissions
#
########################################################################
#
# Exit codes:
#
#  0  --- Success - File found with executable permissions
#  1  --- Error   - File not found
#  2  --- Error   - File does not have execute permissions.
# 99  --- Error   - Command line options incorrect
#
########################################################################

#-- set initial return_code
return_code=99


PRODUCT_LINK="/usr/genprint"
SCRIPTS_DIR="${PRODUCT_LINK}/bin/.scripts"

#-- load the shared script
. ${SCRIPTS_DIR}/shared

#-- initialize
initialize

program_name=`${BASENAME_CMD} $0`

#-- usage_short text
usage_short ()
{
${CAT_CMD} << EOT

USAGE:
    ${program_name} -f filename
    ${program_name} -h
    ${program_name} -v

Try '${program_name} -h' for more information

EOT
}

#-- usage_long text
usage_long ()
{
${CAT_CMD} << EOT

${program_name}
    Checks file permissions

USAGE:
    ${program_name} -f filename
    ${program_name} -h
    ${program_name} -v

OPTIONS:
    -f filename
       Specify the filename.

    -h
       Display this help and exit.

    -v
       Display version information and exit.

EOT
}

while getopts f:hv arg
do   
  case $arg in
        f) filename="${OPTARG}"
           ;;

  	h) usage_long
     	   exit 99
     	   ;;

      v) display_version
           exit 99
           ;;

        *) usage_short
           exit 99
           ;;
  esac
done

if [ -z "${filename}" ];then
     usage_short
     exit 99
fi

if   [ ! -f "${filename}" ];then
     ${PRINT_CMD} "File not found."
     exit 1
elif [ ! -x "${filename}" ];then
     ${PRINT_CMD} "File does not have execute permissions."
     exit 2
else
     ${PRINT_CMD} "File is executable." 
     exit 0
fi

