#!/bin/sh

########################################################################
#             (c) Copyright 2003 Lexmark International, Inc.           #
#                        All rights reserved                           #
########################################################################
#
#  This command is starts the main application.
#
########################################################################

#--
#-- Java VM system defines can be passed to the Java VM by specifying
#-- the defines in the VMDEFINES environment variable. To specify
#-- multiple defines, enclose the define statements in quotes. For
#-- example:
#--
#-- % export VMDEFINES="-Duser.language=de -Duser.region=DE"
#--
#--

#-- set debug to false by default. To turn debug "on" set to "1"
DEBUG=0

#-- initialize variables
APP_NAME="genprint"


PRODUCT_LINK="/usr/genprint"
SCRIPTS_DIR="${PRODUCT_LINK}/bin/.scripts"

#-- load the shared script
. ${SCRIPTS_DIR}/shared

#-- initialize variables:
initialize user
#-- initialize classpath
set_classpath

program_name="genprint"

#-- Trap signal 2 and 15 and exit
trap 2 15

#-- Save the current display
display=${DISPLAY}

#-- Need special Java VM flags, override the JVM_ARGS variable.
if [ -z "${JVM_ARGS}" ]; then
   #-- Set minimum VM size to 16MB set maximum to 96MB
   JVM_ARGS="-ms16m -mx96m"
fi

#-- Need special Java VM flags for languages, override the
#-- VMDEFINES variable. 
if [ -z "${VMDEFINES}" ];then
   if [ ! -z "${APPLICATION_LANG}" ];then
      LANGUAGE="`${PRINT_CMD} ${APPLICATION_LANG} | ${AWK_CMD} -F'_' '{print $1}' | ${SED_CMD} -e 's/\..*$//'`"
      REGION="`${PRINT_CMD} ${APPLICATION_LANG} | ${AWK_CMD} -F'_' '{print $2}' | ${SED_CMD} -e 's/\..*$//'`"
      if [ "${REGION}" = "" ];then
         REGION="${LANGUAGE}"
      fi
      VMDEFINES="-Duser.language=${LANGUAGE} -Duser.region=${REGION} -Duser.locale=${APPLICATION_LANG}"
      LC_ALL=${APPLICATION_LANG}
      export LC_ALL
   fi
fi

#-- usage_short text
usage_short ()
{
${CAT_CMD} << EOT

USAGE:
    ${program_name} [-d display] [-n] [-x]
    ${program_name} [-h]
    ${program_name} [-v]

EOT
}

#-- usage_long text
usage_long ()
{
${CAT_CMD} << EOT

${program_name}
    Provides many features that help ease the task of the system administrator
    and help end-users be more productive.  This includes creating, changing,
    displaying and removing print queues and virtual devices.

    There are two modes of operation:
       1.  Administrator Mode
       2.  User Mode 

USAGE:
    ${program_name} [-d display] [-n] [-x]
    ${program_name} [-h]
    ${program_name} [-v]

OPTIONS:
    -d display
       Specify the X server to contact.

    -n
       Start ${program_name} in user mode.  User mode is only supported for
       non-root users.

    -x
       Run ${program_name} in debug mode.

    -h
       Display this help and exit.

    -v
       Display version information and exit.

FEATURES:
    * Printer Queue and Device Wizards:
      Administrators can use wizards that help ease the setup of virtual devices
      and printer queues.

    * Network Printer Search:
      The search feature helps administators find existing Network Printers
      without knowing exact IP addresses.

    * Frequently Used Options:
      System administrators can create queues with the most frequently used
      options as the default, such as duplex or no banner page, so users do not
      need to specify those options.

    * Printer Options Support:
      Users have the ability to access many printer-specific options such as:
      Multipage Printing, Print and Hold, Duplex, Fax, Optra Forms, Paper Trays,
      Paper Sizes, etc.

    * Job Submission Graphical Interface (${PRINT_GUI}):
      Users can use the command '${PRINT_GUI}' in place of the command 'lp' to access a
      graphical interface to override per-queue options at print time.

    * Individual User Settings:
      Users now have the ability to save personal printer queue settings under 
      their home accounts.

    * Printer Groups (My Printers):
      Users have the ability to create groups of printer queues for easier
      management of large numbers of print queues.

EOT
if [ "${PRT_SUBSYSTEM}" = "SYSTEM_V" ];then
   ${PRINT_CMD} "    * Printer Classes:"
   ${PRINT_CMD} "      Administrators have the ability to manage standard System V printer"
   ${PRINT_CMD} "      classes from within a graphical interface."
   ${PRINT_CMD}
fi
}

#-- parse command line arguments
OPTERR=0
while getopts d:hnvs:Vx? arg
do   
  case $arg in
        d) display="$OPTARG"
           process_display ${display}
           ;;

        h) usage_long
           exit 99
           ;; 

        n) # Option required, Do Nothing. 
           ;; 

        v) display_version
           exit 99
           ;; 

        s) show_java_gui=yes
           number_to_show=$OPTARG
           ;;

        x) DEBUG="1"
           ;;

        *) usage_short
           exit 99
           ;;
  esac
done

#-- Check display
check_display

#-- Setup log filename
if [ ${DEBUG} = "0" ];then
   DEBUG_LOG="/dev/null"
else 
   DEBUG_LOG="/tmp/${APP_NAME}_main.$$"
   ${PRINT_CMD} "Debug Mode:  Everything is being logged to ${DEBUG_LOG}"
fi

is_privileged_user >> ${DEBUG_LOG} 2>&1 
if [ "$?" = "0" ];then
   IS_ADMIN="true"
   #-- Re-initialize for Admin Functions. 
   initialize admin
else
   IS_ADMIN="false"
fi

# look for libXp.so* (RH5 only)
${EGREP_CMD} "Enterprise.*release 5" /etc/redhat-release >/dev/null 2>&1
if [ $? -eq 0 ];then
   XMESSAGE_CMD="/usr/bin/xmessage"
   LIBXP_ERR_MSG="
libXp.so not found!

Install libXp.rpm from your RedHat installation CD 2.

"
   ${LS_CMD} /usr/lib | ${GREP_CMD} "libXp.so" >/dev/null 2>&1
   if [ ! $? -eq 0 ];then
      if [ -x ${XMESSAGE_CMD} ];then
         ${PRINTF_CMD} "${LIBXP_ERR_MSG}" | ${XMESSAGE_CMD} -file - -center
      else
         ${PRINTF_CMD} "${LIBXP_ERR_MSG}" 
      fi
   fi
fi


# look for libXp.so* (Linpus only)
${EGREP_CMD} "Linpus 9.3" /etc/linqus-release >/dev/null 2>&1
if [ $? -eq 0 ];then
   XMESSAGE_CMD="/usr/X11R6/bin/xmessage"
   LIBXP_ERR_MSG="
libXp.so not found!

Install libXp.rpm package.

"
   ${LS_CMD} /usr/X11R6/lib | ${GREP_CMD} "libXp.so" >/dev/null 2>&1
   if [ ! $? -eq 0 ];then
      if [ -x ${XMESSAGE_CMD} ];then
         ${PRINTF_CMD} "${LIBXP_ERR_MSG}" | ${XMESSAGE_CMD} -file - -center
      else
         ${PRINTF_CMD} "${LIBXP_ERR_MSG}" 
      fi
   fi
fi




#-- CLASSPATH is set in shared
MAIN_TARGET="com.lexmark.unix.drivers.jprint.jprint.JPrint"
MESSAGE_TARGET="com.lexmark.unix.drivers.jprint.util.ShowLPDMessages"
SETUP_TARGET="com.lexmark.unix.drivers.jprint.setup.Setup"

if [ "${show_java_gui}" = "yes" ];then
   ${JAVA_CMD} ${VMDEFINES} -cp ${CLASSPATH} ${MESSAGE_TARGET} ${number_to_show}
   exit 0
fi


#-- Stop for setup
if [ ! -f "${ROOT_SPOOL_DIR}/.${PRODUCT_NAME}/props/gen.properties" ];then
	if [ "${IS_ADMIN}" = "false" ];then
		${JAVA_CMD} ${VMDEFINES} -cp ${CLASSPATH} ${MESSAGE_TARGET} 15 >> ${DEBUG_LOG} 2>&1
		exit 1
	else
		license_agreement "admin" "show_gui"
		${JAVA_CMD} ${VMDEFINES} -cp ${CLASSPATH} ${SETUP_TARGET} >> ${DEBUG_LOG} 2>&1
		case ${?} in
			0 ) ;;
			1 ) ${PRINT_CMD} "Setup failed."    ;  exit 1 ;;
			2 ) ${PRINT_CMD} "Setup cancelled." ;  exit 2 ;;
			* ) ${PRINT_CMD} "Setup failed."    ;  exit 3 ;;
		esac
	fi
fi

#-- Check for License Agreement
if [ "${IS_ADMIN}" = "true" ];then
	license_agreement "admin" "show_gui"
else
	license_agreement "user" "show_gui"
fi

if [ "${IS_ADMIN}" = "true" ];then
   ${SCRIPTS_DIR}/print_daemon.sh >> ${DEBUG_LOG} 2>&1 
   pd_rc="${?}"
   verify_print_subsystem ${pd_rc}
   pd_rc2="${?}"
   if [ "${pd_rc}" != "0" ] && [ "${pd_rc}" != "1" ];then
      ${JAVA_CMD} ${VMDEFINES} -cp ${CLASSPATH} ${MESSAGE_TARGET} ${pd_rc} >> ${DEBUG_LOG} 2>&1
      if [ "${?}" != "0" ];then
         exit 1
      fi
   elif [ "${pd_rc2}" = "6" ];then
      ${JAVA_CMD} ${VMDEFINES} -cp ${CLASSPATH} ${MESSAGE_TARGET} 6 >> ${DEBUG_LOG} 2>&1
      exit 1
   fi
else
   check_spool_dir_permissions >/dev/null 2>&1
   if [ "${?}" != "0" ];then
      ${JAVA_CMD} ${VMDEFINES} -cp ${CLASSPATH} ${MESSAGE_TARGET} 14 >> ${DEBUG_LOG} 2>&1
      exit 1
   fi
fi

#-- License Agreement accepted, continue

if [ "${DEBUG}" = "1" ];then
   {
      ${PRINT_CMD}
      ${PRINT_CMD} "JAVA COMMAND:"
      ${PRINT_CMD} "${JAVA_CMD} ${JVM_ARGS} ${VMDEFINES} -cp ${CLASSPATH} ${MAIN_TARGET} ${IS_ADMIN}"
      ${PRINT_CMD} 
   } >> ${DEBUG_LOG} 2>&1
fi

LANG=${APPLICATION_LANG}
export LANG

${JAVA_CMD} ${JVM_ARGS} ${VMDEFINES} -cp ${CLASSPATH} ${MAIN_TARGET} ${IS_ADMIN} ${PDUSER} ${PDHOME} >> ${DEBUG_LOG} 2>&1
RC="${?}"
while [ "${RC}" = "6" ]
do
	set_classpath
	${JAVA_CMD} ${JVM_ARGS} ${VMDEFINES} -cp ${CLASSPATH} ${MAIN_TARGET} ${IS_ADMIN} ${PDUSER} ${PDHOME} >> ${DEBUG_LOG} 2>&1
	RC="${?}"
done

exit ${?} 

