#!/bin/sh
########################################################################
#             (c) Copyright 2003 Lexmark International, Inc.           #
#                        All rights reserved                           #
########################################################################
#                                                                      #
# This command calls the appropriate mkqueue command.                  #
#                                                                      #
########################################################################


PRODUCT_LINK="/usr/genprint"
SCRIPTS_DIR="${PRODUCT_LINK}/bin/.scripts"
O_OPT=""

#-- load the shared script
. ${SCRIPTS_DIR}/shared

#-- initialize variables:
initialize user

process_options()
{
    if [ "${plang}" = "raw" ];then
       return
    fi
    for option in `${PRINT_CMD} ${printer_options}`
    do
       ${PRINT_CMD} ${option} | ${EGREP_CMD} ".=." >/dev/null 2>&1
       if [ $? -ne 0 ];then
          continue
       fi
       ${PRINT_CMD} ${option} | ${EGREP_CMD} "pcl_|ps_|forms_|iq_|pdf_|ppds_" >/dev/null 2>&1
       if [ $? -eq 0 ];then
          option="`${PRINT_CMD} ${option} | ${SED_CMD} -e 's/^pdf_/iq_/g'`"
          cmd_p_opts="${cmd_p_opts} ${option}"
       else
          case ${plang} in 
               'pcl') cmd_p_opts="${cmd_p_opts} pcl_${option}" ;;
                'ps') cmd_p_opts="${cmd_p_opts} ps_${option}" ;;
             'forms') cmd_p_opts="${cmd_p_opts} forms_${option}" ;;
                'iq') cmd_p_opts="${cmd_p_opts} iq_${option}" ;;
              'ppds') cmd_p_opts="${cmd_p_opts} ppds_${option}" ;;
                   *) cmd_p_opts="${cmd_p_opts} pcl_${option} ps_${option} iq_${option}" ;;
          esac
       fi
    done
    O_OPT="-o"
}

while getopts GL:a:d:o:q:p:l:svhx arg
do
  case "${arg}" in
     o) if [ -z "${printer_options}" ];then
           printer_options="${OPTARG}"
        else
           printer_options="${printer_options} ${OPTARG}"
        fi
        ;;
     l) plang="${OPTARG}"
        cmd_opts="${cmd_opts} -${arg} ${OPTARG}"
        ;;
     ?) cmd_opts="${cmd_opts} -${arg} ${OPTARG}"
        ;;
  esac
done

if [ ! -z "${printer_options}" ];then 
   process_options ${printer_options}
fi

#-- Put Lang back before calling next script
LANG=${APPLICATION_LANG}
export LANG

if   [ "${PRT_SUBSYSTEM}" = "BSD" ];then
     ${SCRIPTS_DIR}/bsd_mkqueue.sh ${cmd_opts} ${O_OPT} "${cmd_p_opts}"
elif [ "${PRT_SUBSYSTEM}" = "SYSTEM_V" ];then
     ${SCRIPTS_DIR}/sysv_mkqueue.sh ${cmd_opts} ${O_OPT} "${cmd_p_opts}"
fi
exit ${?}
