#!/bin/sh

APPLICATION_DIR="/usr/genprint"
PRODUCT_NAME="genprint"
APPLICATION_NAME="Print Drivers"
OEM=""
LINK_DIR="${OEM}_prt_utils"
DESKTOP_FILE="${PRODUCT_NAME}.desktop"

FOLDER_ICON="${APPLICATION_DIR}/etc/icons/folder.png"
APP_ICON="${APPLICATION_DIR}/etc/icons/application.png"
APPLICATION="${APPLICATION_DIR}/bin/${PRODUCT_NAME}"
TITLE="GNOME Menu Utility"

LS_CMD="/bin/ls"
EGREP_CMD="/bin/egrep"
GREP_CMD="/bin/grep"
CHMOD_CMD="/bin/chmod"
MKDIR_CMD="/bin/mkdir"
RMDIR_CMD="/bin/rmdir"
TOUCH_CMD="/bin/touch"
RM_CMD="/bin/rm"
CHGRP_CMD="/bin/chgrp"
ECHO_CMD="/bin/echo"
PRINTF_CMD="/usr/bin/printf"
SED_CMD="/bin/sed"
CAT_CMD="/bin/cat"
CHOWN_CMD="/bin/chown"
FIND_CMD="/usr/bin/find"
TR_CMD="/usr/bin/tr"
CP_CMD="/bin/cp"
EXPR_CMD="/usr/bin/expr"
LN_CMD="/bin/ln"
WC_CMD="/usr/bin/wc"
if [ -x "/bin/awk" ];then     AWK_CMD="/bin/awk"  ; else AWK_CMD="/usr/bin/awk" ; fi
if [ -x "/usr/bin/id" ];then  ID_CMD="/usr/bin/id"; else ID_CMD="/bin/id"       ; fi

#######################################################
#
#  This function checks for user 'root'. 
#
#######################################################
check_for_root ()
{
   ${ID_CMD} | ${GREP_CMD} "uid=0" >/dev/null 2>&1
   if [ "${?}" != "0"  ]; then
      ${ECHO_CMD} "You must be root to run this script."
      exit 1
   fi
}

#######################################################
#
#  This function looks for standard GNOME Directories
#  and sets the GNOME path or exits if GNOME is not found.
#
#######################################################
check_for_gnome ()
{
   if   [ -d /opt/gnome/share/applications ]; then
        #-- SuSE GNOME directory structure
        GNOME_DIR=/opt/gnome/share/applications
        GNOME2="yes"
        MESSAGE="Utilities / Printing"
        CATEGORY="Categories=GNOME;Application;Utility;Utility;X-SuSE-PrintingUtility"
   elif [ -d /etc/opt/gnome/SuSE ]; then
        #-- SuSE GNOME directory structure
        GNOME_DIR=/etc/opt/gnome/SuSE
        GNOME2="no"
        CATEGORY="Categories=Application;System;X-Red-Hat-Base;"
   elif [ -d /opt/gnome/share/gnome/apps ]; then
        #-- SuSE GNOME directory structure
        GNOME_DIR=/opt/gnome/share/gnome/apps
        GNOME2="no"
        CATEGORY="Categories=Application;System;X-Red-Hat-Base;"
   elif [ -d  /usr/share/applications ]; then
        # RedHat 8.0 GNOME directory structure
        GNOME_DIR=/usr/share/applications
        GNOME2="yes"
        MESSAGE="System Tools"
        CATEGORY="Categories=Application;System;X-Red-Hat-Base;"
   elif [ -d  /usr/share/gnome/apps ]; then
        # RedHat < 8.0 GNOME directory structure
        GNOME_DIR=/usr/share/gnome/apps
        GNOME2="no"
        CATEGORY="Categories=Application;System;X-Red-Hat-Base;"
   else
        #-- GNOME Directories not found, exit
        ${ECHO_CMD}
        ${ECHO_CMD} "Error:  GNOME Menu directories were not found."
        ${ECHO_CMD} "        Either GNOME is not installed or GNOME was installed"
        ${ECHO_CMD} "        in a non standard directory."
        ${ECHO_CMD}
        exit 1
   fi
}

#######################################################
#
#  This function displays the GNOME Utility Menu.
#
#######################################################
display_menu ()
{
   continue="no"

   ${ECHO_CMD}
   ${ECHO_CMD} "${OEM} ${TITLE}"
   ${ECHO_CMD} 
   ${ECHO_CMD} "  1. Install ${OEM} applications."
   ${ECHO_CMD} "  2. Remove ${OEM} applications."
   ${ECHO_CMD} "  3. Exit."
   ${ECHO_CMD}
   ${PRINTF_CMD} "Enter your choice : [3] "
   while [ "${continue}" = "no" ]
   do
       read ans
       if   [ "${ans}" = "1" -o "${ans}" = "2" -o "${ans}" = "3" ];then
            continue="yes"
       elif [ "${ans}" = "" ];then
            continue="yes"
       else
            ${ECHO_CMD} 
            ${PRINTF_CMD} "Invalid choice. Enter your choice : "
       fi
   done

   if   [ "${ans}" = "1" ];then
        run_type=install
   elif [ "${ans}" = "2" ];then
        run_type=remove
   else
        ${ECHO_CMD}
        exit 0
   fi
}

create_desktop_file ()
{

${CAT_CMD} << EOT
[Desktop Entry]
Encoding=UTF-8
Name=${OEM} Print Drivers
Name[de]=${OEM} Drucktreiber
Name[es]=Controladores de impresión ${OEM}
Name[fr]=Pilotes d'imprimante ${OEM}
Name[it]=Driver di stampa ${OEM}
Name[ja]=${OEM} プリント ドライバ
Name[ko]=${OEM} 인쇄 드라이버 정보
Name[pt_BR]=Drivers de impressão da ${OEM}
Name[zh_CN]=${OEM} 打印驱动程序
Name[zh_TW]=${OEM} 列印驅動程式

Icon=${APP_ICON}
Type=Application
Exec=${APPLICATION}
Terminal=false
X-Desktop-File-Install-Version=0.3
EOT
${ECHO_CMD} ${CATEGORY}

}

create_directory_entry ()
{

${CAT_CMD} << EOT
[Desktop Entry]
Name=${OEM} Printer Utilities
Comment=Printer Related Software
Icon=${FOLDER_ICON}
Type=Directory
EOT

}

#-- SCRIPT STARTS HERE --#

#-- Check to see if the current user is root.
check_for_root

#-- Check to see if we can find GNOME. 
check_for_gnome

#-- Note: GNOME_DIR is set in the check_for_gnome function
MENU_DIR="${GNOME_DIR}/${LINK_DIR}"
APP_FILE="${MENU_DIR}/${DESKTOP_FILE}"
GNOME2_APP_FILE="${GNOME_DIR}/${DESKTOP_FILE}"

#-- Display GNOME Utility Menu 
while getopts irn  arg
do
	case $arg in
		i) run_type=install
			;;
		r) run_type=remove
			;;
		n) TITLE="Menu Utility"
			;;
	esac
done
if [ -z "$run_type" ];then
   display_menu
fi

if [ "${run_type}" = "install" ];then
   #-- Create Menu directory if it does not exist.
   if [ "${GNOME2}" = "yes" ];then
      if [ -f "${GNOME2_APP_FILE}" ];then
         ${RM_CMD} -f ${GNOME2_APP_FILE}
         if [ "${?}" != "0" ];then
	         ${ECHO_CMD} "Error: GNOME Menu option could not be removed."
            ${ECHO_CMD} "       File: ${GNOME2_APP_FILE}"
            exit 1
         fi
      fi
      create_desktop_file > ${GNOME2_APP_FILE}
      if [ "${?}" != "0" ];then
	      ${ECHO_CMD} "Error: GNOME Menu option could not be created."
         ${ECHO_CMD} "       File: ${GNOME2_APP_FILE}"
         exit 1
      else
         ${ECHO_CMD} "Desktop Menu [ ${MESSAGE} ] has been updated."
         exit 0
      fi
   fi

   #-- None RedHat 8 System 
   if [ ! -d "${MENU_DIR}" ];then
      mkdir ${MENU_DIR}
      if [ "${?}" != "0" ];then
	      ${ECHO_CMD} "Error: GNOME Menu directory could not be created."
         ${ECHO_CMD} "       Directory: ${MENU_DIR}"
         exit 1
      fi
   fi

   #-- Update the Menu Directory File.
   if [ -f "${MENU_DIR}/.directory" ];then
      ${RM_CMD} -f ${MENU_DIR}/.directory
      if [ "${?}" != "0" ];then
	      ${ECHO_CMD} "Error: GNOME Menu directory file could not be removed."
         ${ECHO_CMD} "       File: ${MENU_DIR}/.directory"
         exit 1
      fi
   fi
   create_directory_entry > ${MENU_DIR}/.directory
   if [ "${?}" != "0" ];then
      ${ECHO_CMD} "Error: GNOME Menu directory file could not be created."
      ${ECHO_CMD} "       File: ${MENU_DIR}/.directory"
      exit 1
   fi

   #--Create or Update application link 
   if [ -f "${APP_FILE}" ];then
      ${RM_CMD} -f ${APP_FILE}
      if [ "${?}" != "0" ];then
	      ${ECHO_CMD} "Error: GNOME Menu option could not be removed."
         ${ECHO_CMD} "       File: ${APP_FILE}"
         exit 1
      fi
   fi
   create_desktop_file > ${APP_FILE}
   if [ "${?}" != "0" ];then
      ${ECHO_CMD} "Error: GNOME Menu option could not be created."
      ${ECHO_CMD} "       File: ${APP_FILE}"
      exit 1
   fi
	if [ -d "${SUSE_GNOME_DIR}" ];then
      ${CP_CMD} ${APP_FILE} ${SUSE_GNOME_DIR}
   fi
   ${ECHO_CMD} "Adding GNOME Menu entry was successful."
   exit 0
else
   #-- Remove GNOME application links.

   if [ "${GNOME2}" = "yes" ];then 
      #-- Check for GNOME application link
      if [ -f "${GNOME2_APP_FILE}" ];then
         ${RM_CMD} -f ${GNOME2_APP_FILE}
	 		${ECHO_CMD} "Removing ${OEM} menu entries was successful."
         exit 0
      else
	 		${ECHO_CMD} "${OEM} menu entries are not installed."
         exit 1
      fi
   fi

   #-- Check for GNOME menu directory
   if [ ! -d "${MENU_DIR}" -o ! -f "${APP_FILE}" ];then
	 	${ECHO_CMD} "${OEM} menu entries are not installed."
      exit 1
   fi

   desktop_files=`${LS_CMD} -1 ${MENU_DIR} | ${GREP_CMD} ".desktop"`
   if [ "${?}" != "0" ];then
      #-- No desktop files found, just remove directory.
      ${RM_CMD} -f ${MENU_DIR}/.directory
      ${RMDIR_CMD} ${MENU_DIR}
   else 
	if [ -f "${SUSE_GNOME_DIR}/${DESKTOP_FILE}" ];then
         ${RM_CMD} -f "${SUSE_GNOME_DIR}/${DESKTOP_FILE}"
         ${ECHO_CMD} "Removing GNOME Application Link was successful."
    fi 
      ${PRINTF_CMD} "${desktop_files}\n" | ${WC_CMD} -l | ${EGREP_CMD} -e "^ *1 *$" >/dev/null 2>&1
      if [ "${?}" = "0" ];then
         ${RM_CMD} -f ${APP_FILE}
         ${RM_CMD} -f ${MENU_DIR}/.directory
         ${RMDIR_CMD} ${MENU_DIR}
         ${ECHO_CMD} "Removing GNOME Menu entry was successful."
         exit 0
      else
         ${RM_CMD} -f ${APP_FILE}

         ${ECHO_CMD} "Removing GNOME Application Link was successful."
         exit 0
      fi
   fi
fi

exit 0
