#!/bin/sh

INSTALL_DIR="/usr/genprint"
PROGRAM_NAME="Print Drivers"
PRODUCT_NAME="genprint"
VAR_DIR="/var/spool"/printer/unix_prt_drivers/.${PRODUCT_NAME}

LS_CMD="/bin/ls"
EGREP_CMD="/bin/egrep"
GREP_CMD="/bin/grep"
CHMOD_CMD="/bin/chmod"
MKDIR_CMD="/bin/mkdir"
TOUCH_CMD="/bin/touch"
RM_CMD="/bin/rm"
MV_CMD="/bin/mv"
CHGRP_CMD="/bin/chgrp"
ECHO_CMD="/bin/echo"
PRINTF_CMD="/usr/bin/printf"
SED_CMD="/bin/sed"
CAT_CMD="/bin/cat"
CHOWN_CMD="/bin/chown"
FIND_CMD="/usr/bin/find"
TR_CMD="/usr/bin/tr"
CP_CMD="/bin/cp"
EXPR_CMD="/usr/bin/expr"
LN_CMD="/bin/ln"
if [ -x "/bin/awk" ];then     AWK_CMD="/bin/awk"  ; else AWK_CMD="/usr/bin/awk" ; fi
if [ -x "/usr/bin/id" ];then  ID_CMD="/usr/bin/id"; else ID_CMD="/bin/id"       ; fi

ARG="${1}"

check_for_root()
{
   #-- Make user the user is root
   ${ID_CMD} | ${GREP_CMD} "uid=0">/dev/null 2>&1
   if [ "${?}" = "0" ]; then
      return 0
   else
      return 1
   fi
}

write_file()
{
   #-- Function no longer needed.
   ${ECHO_CMD} >> /dev/null 
}

remove_file()
{
   #-- Function no longer needed.
   ${ECHO_CMD} >> /dev/null 
}

suse_version()
{
    VERSION=`${CAT_CMD} /etc/SuSE-release | ${GREP_CMD} "VERSION" | ${SED_CMD} -e 's/.*= //g' -e 's/ //g'`
    ${CAT_CMD} /etc/SuSE-release | ${GREP_CMD} "Server" >/dev/null 2>&1
    if [ $? -eq 0 ];then
       TYPE="`${CAT_CMD} /etc/SuSE-release | ${SED_CMD} 1q | ${AWK_CMD} '{print $3}'`"
       ${PRINTF_CMD} "SUSE LINUX ${TYPE} Server [ ${VERSION} ] Distribution.\n"
    else
       ${CAT_CMD} /etc/SuSE-release |${GREP_CMD} "SLES" >/dev/null 2>&1
       if [ $? -eq 0 ];then
          ${PRINTF_CMD} "SUSE LINUX Enterprise Server [ ${VERSION} ] Distribution.\n"
       else
          ${PRINTF_CMD} "SUSE LINUX [ ${VERSION} ] Distribution.\n"
       fi
    fi
}

novell_version()
{
    VERSION=`${CAT_CMD} /etc/novell-release | ${GREP_CMD} "VERSION" | ${SED_CMD} -e 's/.*= //g' -e 's/ //g'`
    ${PRINTF_CMD} "Novell Linux Desktop [ ${VERSION} ] Distribution. (Unsupported)\n"
}


fedora_version()
{
    VERSION="`${CAT_CMD} /etc/redhat-release`"
    ${PRINTF_CMD} "${VERSION} (Unsupported)\n"
}

redhat_version()
{
    ${CAT_CMD} /etc/redhat-release | ${GREP_CMD} "Enterprise" >/dev/null 2>&1
    if [ $? -eq 0 ];then
       check_for_root
       if [ $? -eq 0 ];then
          ${CAT_CMD} /etc/redhat-release | ${GREP_CMD} "release 4 " >/dev/null 2>&1
          if [ $? -eq 0 ];then
             cd ${INSTALL_DIR}/jre/lib
             if [ -f "font.properties.ja.Redhat8.0" ];then 
                ${RM_CMD} -f font.properties.ja
                ${CAT_CMD} font.properties.ja.Redhat8.0 | ${SED_CMD} -e 's/\.ttf/-subst.ttf/g' > font.properties.ja
             fi
          fi
          ${CAT_CMD} /etc/redhat-release | ${GREP_CMD} "release 5 " >/dev/null 2>&1
          if [ $? -eq 0 ];then
             cd ${INSTALL_DIR}/jre/lib
             if [ -f "font.properties.ko.Redhat" ];then 
                ${MV_CMD} -f font.properties.ko.Redhat font.properties.ko
                ${CAT_CMD} font.properties.ko | ${SED_CMD} -e 's/\/fonts\/ko\/TrueType/\/fonts\/korean\/TrueType/g' > font.properties.ko.Redhat
             fi
             if [ -f "font.properties.ko.Redhat" ];then 
                ${MV_CMD} -f font.properties.ko.Redhat font.properties.ko
                ${CAT_CMD} font.properties.ko | ${SED_CMD} -e 's/\/fonts\/ko\/TrueType/\/fonts\/korean\/TrueType/g' > font.properties.ko.Redhat
             fi
             if [ -f "font.properties.zh_CN.Redhat" ];then 
                ${MV_CMD} -f font.properties.zh_CN.Redhat font.properties.zh_CN
                ${CAT_CMD} font.properties.zh_CN | ${SED_CMD} -e 's/\/fonts\/zh_CN\/TrueType/\/fonts\/chinese\/TrueType/g' > font.properties.zh_CN.Redhat
		${CP_CMD} -f font.properties.zh_CN.Redhat font.properties.zh_SG.Redhat
             fi
             if [ -f "font.properties.zh_TW.Redhat" ];then 
                ${MV_CMD} -f font.properties.zh_TW.Redhat font.properties.zh_TW
                ${CAT_CMD} font.properties.zh_TW | ${SED_CMD} -e 's/\/fonts\/zh_TW\/TrueType\/bsmi00lp.ttf/\/fonts\/chinese\/TrueType\/uming.ttf/g' | ${AWK_CMD} '$0 ~ /bold/{print "#" $0 ;next}{print}' > font.properties.zh_TW.Redhat
		${CP_CMD} -f font.properties.zh_TW.Redhat font.properties.zh_HK.Redhat
             fi
          fi
       fi
       ${PRINTF_CMD} "`${CAT_CMD} /etc/redhat-release`\n"
      
    else
       VERSION="`${CAT_CMD} /etc/redhat-release | ${AWK_CMD} '{print $5}'`"
       ${PRINTF_CMD} "RedHat [ ${VERSION} ] Distribution.\n"
    fi
}

mandrake_version()
{
    VERSION="`${CAT_CMD} /etc/mandrake-release | ${AWK_CMD} '{print $4}'`"
    ${PRINTF_CMD} "Mandrake Linux [ ${VERSION} ] Distribution. (Unsupported)\n"
}

linpus_version()
{
       ${EGREP_CMD} "Linpus 9.3" /etc/linqus-release >/dev/null 2>&1
       if [ $? -eq 0 ];then
	VERSION="9.3"
       else
	${GREP_CMD} "VERSION=" /etc/linpus-release >/dev/null 2>&1
	if [ ${?} -eq 0 ];then
		VERSION="`${GREP_CMD} "VERSION=" /etc/linpus-release | ${SED_CMD} -e 's/.*=//g'`"
	else
		VERSION="`${AWK_CMD} '{print $4}' /etc/linpus-release`"
	fi
       fi

    ${PRINTF_CMD} "Linpus [ ${VERSION} ] Distribution.\n"
    #-- Set support for missing lp and lpstat links.
    check_for_root
    if [ $? -eq 0 ];then
       /bin/ls /usr/bin/lp /usr/bin/lpstat >/dev/null 2>&1
       if [ $? -ne 0 ];then
          /bin/touch ${VAR_DIR}/.linpus
       else
          if [ -f "${VAR_DIR}/.linpus" ];then
             ${RM_CMD} -f ${VAR_DIR}/.linpus
          fi
       fi

       #-- Set font.properties file.
       cd ${INSTALL_DIR}/jre/lib
       if [ -f "font.properties.zh_TW.Redhat" ];then 
          /bin/cp -f font.properties.zh_TW.Redhat font.properties.zh_TW
       fi
        #Linpus 9.3 only
       ${EGREP_CMD} "Linpus 9.3" /etc/linqus-release >/dev/null 2>&1
       if [ $? -eq 0 ];then
          ${CAT_CMD} font.properties.zh_TW.Redhat | ${SED_CMD} -e 's/\/fonts\/zh_TW\/TrueType\/bsmi00lp.ttf/\/fonts\/chinese\/TrueType\/bsmi00lp.ttf/g' | ${AWK_CMD} '$0 ~ /bold/{print "#" $0 ;next}{print}' > font.properties.zh_TW
       fi

	
       #-- Set font.properties file.
    fi
}

linspire_version()
{
    VERSION="`${GREP_CMD} "Version:" /etc/linspire-version | ${SED_CMD} -e 's/.*: *//g'`"
    ${PRINTF_CMD} "Linspire [ ${VERSION} ] Distribution.\n"

    #-- Fix CUPS Backend
    if [ -d "/usr/lib/cups/backend" ];then
       if [ ! -e "/usr/lib/cups/backend/file" ];then
          ${LN_CMD} -s /bin/true /usr/lib/cups/backend/file
       fi
    fi
}

lindows_version()
{
    VERSION="`${CAT_CMD} /etc/lindowsos-version | ${AWK_CMD} '{print $3}'`"
    ${PRINTF_CMD} "Lindows [ ${VERSION} ] Distribution.\n"

    #-- Fix CUPS Backend
    if [ -d "/usr/lib/cups/backend" ];then
       if [ ! -e "/usr/lib/cups/backend/file" ];then
          ${LN_CMD} -s /bin/true /usr/lib/cups/backend/file
       fi
    fi
}

debian_version()
{
    ${PRINTF_CMD} "Debian GNU/Linux Distribution.\n"
}

redflag_version()
{
    ${CAT_CMD} /etc/redflag-release | ${GREP_CMD} "6.0" >/dev/null 2>&1
    if [ $? -eq 0 ];then
	VERSION="6.0"
    else
	VERSION="`${CAT_CMD} /etc/redflag-release | ${AWK_CMD} '{print $5}'`"
    fi
	${PRINTF_CMD} "Redflag [ ${VERSION} ] Distribution.\n"

    #-- Set font.properties file.
    check_for_root
    if [ $? -eq 0 ];then
       cd ${INSTALL_DIR}/jre/lib
       if [ -f "font.properties.zh.Turbo" ] && [ "${VERSION}" = "6.0" ];then 
          ${CAT_CMD} font.properties.zh_CN.Redhat | ${SED_CMD} -e 's/zysong/rfdw/g' > font.properties.zh
       else
          /bin/cp -f font.properties.zh.Turbo font.properties.zh
       fi
    fi
    #-- Set font.properties file.
}

unknown_version()
{
    ${PRINTF_CMD} "Linux Distribution. (Unsupported)\n"
}

#-- Searching for System Distribution Type.
if   [ -f /etc/novell-release    ]; then
     novell_version 
     exit 0
elif [ -f /etc/SuSE-release    ]; then
     suse_version 
     exit 0
elif [ -f /etc/linpus-release  ];then
     linpus_version
     exit 0
elif [ -f /etc/mandrake-release  ];then
     mandrake_version
     exit 0
elif [ -f /etc/fedora-release  ];then
     fedora_version
     exit 0
elif [ -f /etc/linspire-version ];then
     linspire_version
     exit 0
elif [ -f /etc/lindowsos-version ];then
     lindows_version
     exit 0
elif [ -f /etc/redflag-release   ];then
     redflag_version
     exit 0
elif [ -f /etc/redhat-release  ];then
     redhat_version
     exit 0
elif [ -f /etc/debian_version ];then
     debian_version 
     exit 0
else
     unknown_version
     exit 0
fi

exit 0
