#!/bin/sh
#
#	
#	File: 	print_filter
#
#	Description:
#
#		This script works as an input filter for the 
#		BSD printer sub-system backend. It calls
#		The appropriate programs to pre-pend the data
#		with the printer codes according to how the virtual 
#		queue and devices are setup.
#
#--------------------------------------------------------------------
APPLICATION_DIR="/usr/genprint"
FORMAT_PROGRAM="process_printjob"
BUILD_TRANSPORT_CMD="process_printcmd"

#--------------------------------------------------------------------
#
#	Procedure:	run_first
#
#	Description:
#
#		This subroutine is called to run the formatter 
#		program first to print the banner page and the second 
#		time to send the data to the standard output which will 
#		be intercepted by the transport program output and sent 
#		to the printer according to how the virtual device is 
#		setup.
#
#--------------------------------------------------------------------

run_first()
{
	#
	# Call the formatter and see if you can print the banner
	# page using the -b option if the banner is enable by the
	# queue.
	#
	if [ ${DEBUG} = "1" ];then
	   echo "${APPLICATION_DIR}/bin/${FORMAT_PROGRAM} -b -q \"$printer\" -h \"$hostname\" -u \"$username\" -s \"$jobname\" -p \"$option_list\"" >> /tmp/marknet_filter.debug$$
	fi

	${APPLICATION_DIR}/bin/${FORMAT_PROGRAM} -b -q "$printer" -h "$hostname" -u "$username" -s "$jobname" -p "$option_list"

	#
	# Now send the data to the queue, which is coming through 
	# stdin of this script and becomes the stdin of the formatter
	#
	if [ ${DEBUG} = "1" ];then
	   echo "${APPLICATION_DIR}/bin/${FORMAT_PROGRAM} -q \"$printer\" -h \"$hostname\" -u \"$username\" -s \"$jobname\" -p \"$option_list\"" >> /tmp/marknet_filter.debug$$
	fi
	${APPLICATION_DIR}/bin/${FORMAT_PROGRAM} -q "${printer}" -h "$hostname"  -u "$username" -s "$jobname" -p "$option_list"

	return 0
}

#--------------------------------------------------------------------
#
#	Procedure:	cleanup
#
#	Description:
#
#		This procedure will cleanup any temporary files.
#
#--------------------------------------------------------------------

cleanup()
{
	if [ -f /tmp/t$$ ] 
	then
   		/bin/rm -f /tmp/t$$
 	fi

	return 
}

#--------------------------------------------------------------------
#
# 			The script starts here 
#
#--------------------------------------------------------------------

# set DEBUG=0 to turn debugging OFF
# set DEBUG=1 to turn debugging ON

DEBUG=0

if [ "$DEBUG" = 1 ] ; then
	echo "*** argv = $*" >> /tmp/marknet_filter.debug$$
fi


#
# Process command line arguments
#
# set -- `/usr/bin/getopt cw:l:i:n:h: "$@"`
set -- "$@"

while [ "$1" != "" ]
do
	case "$1" in
   		-c ) 
			raw=yes
			if [ "$DEBUG" = 1 ] ; then echo "*** saw -c arg $1" >> /tmp/marknet_filter.debug$$ ; fi
			;;
   		-w* )  	
			if [ "$1" != "-w" ] ; then
				page_width=`echo "$1" | cut -c 3-`
				if [ "$DEBUG" = 1 ] ; then echo "*** saw -w arg $1 = $page_width" >> /tmp/marknet_filter.debug$$ ; fi
			elif [ "$2" != "0" ] ; then
				page_width="$2"   
				if [ "$DEBUG" = 1 ] ; then echo "*** saw -w arg $1 = $page_width" >> /tmp/marknet_filter.debug$$ ; fi
         			shift 1
         		fi
			;;
   		-l* ) 
			if [ "$1" != "-l" ] ; then
				lines_per_page=`echo "$1" | cut -c 3-`
				if [ "$DEBUG" = 1 ] ; then  echo "*** saw -l arg $1 = $lines_per_page" >> /tmp/marknet_filter.debug$$ ; fi
			elif [ "$2" != "0" ] ; then
				lines_per_page="$2"
				if [ "$DEBUG" = 1 ] ; then echo "*** saw -l arg $1 = $lines_per_page" >> /tmp/marknet_filter.debug$$ ; fi
				shift 1
			fi
			;;
   		-i* )  
			if [ "$1" != "-i" ] ; then
				indent=`echo "$1" | cut -c 3-`
				if [ "$DEBUG" = 1 ] ; then echo "*** saw -i arg $1 = $indent" >> /tmp/marknet_filter.debug$$ ; fi
			elif [ "$2" != "0" ] ; then
           			indent="$2"
				if [ "$DEBUG" = 1 ] ; then echo "*** saw -i arg $1 = $indent" >> /tmp/marknet_filter.debug$$ ; fi
         			shift 1
         		fi
			;;
   		-n* ) 
			if [ "$1" != "-n" ] ; then
				user=`echo "$1" | cut -c 3-`
				if [ "$DEBUG" = 1 ] ; then echo "*** saw -n arg $1 = $user" >> /tmp/marknet_filter.debug$$ ; fi
			elif [ "$2" != "-h" ] ; then
				user="$2"
				if [ "$DEBUG" = 1 ] ; then echo "*** saw -n arg $1 = $user" >> /tmp/marknet_filter.debug$$ ; fi
				shift 1
			else
				user="unknown"
				if [ "$DEBUG" = 1  ] ; then echo "*** saw -n arg $1 = $user" >> /tmp/marknet_filter.debug$$ ; fi
			fi
			;;
   		-h* ) 
			if [ "$1" != "-h" ] ; then
				host=`echo "$1" | cut -c 3-`
				if [ "$DEBUG" = 1 ] ; then echo "*** saw -h arg $1 = $host" >> /tmp/marknet_filter.debug$$ ; fi
			elif [ "$2" != "-h" ] ; then
				host="$2"
				if [ "$DEBUG" = 1 ] ; then echo "*** saw -h arg $1 = $host" >> /tmp/marknet_filter.debug$$ ; fi
				shift 1
			else
				user="unknown"
				if [ "$DEBUG" = 1 ] ; then echo "*** saw -h arg $1 = $host" >> /tmp/marknet_filter.debug$$ ; fi
			fi
			;;
   		-k* ) 
			if [ "$1" != "-k" ] ; then
				LPRng_control_file=`echo "$1" | cut -c 3-`
				if [ "$DEBUG" = 1 ] ; then  echo "*** saw -k arg $1 = $LPRng_control_file" >> /tmp/marknet_filter.debug$$ ; fi
				shift 1
			fi
			;;
 	esac
	shift 1
done

#
# Trap signal 2 and 15 and exit
#
trap "cleanup; exit 0" 2 15

#
# get the name of the queue
#

printer=`pwd`
printer="`basename $printer`" 

#
# Find the job info file from the lock file.  It's on the last line.
#

if [ -f lock ] ; then
   if [ -f /usr/ucb/tail ] ; then
	FILE="`cat lock | /usr/ucb/tail -1`"
   else
	FILE="`cat lock | /usr/bin/tail -1`"
   fi
else
   if [ -f "$LPRng_control_file" ] ; then
       if [ -f /usr/ucb/tail ] ; then
          FILE="`echo ${LPRng_control_filer} | /usr/ucb/tail`"
       else
          FILE="`echo ${LPRng_control_file} | /usr/bin/tail`"
       fi
   fi
fi

#
# Extract the info from file by inserting an = between the first and
# second char on each line.  The second char thru the last are surrounded
# by two quotation marks encase there are white spaces.
#

if [ -f lock ] ; then
   if [ "$DEBUG" = 1 ] ; then cat $FILE  >> /tmp/FILE ; fi
   cat $FILE | sed -e 's/^\(.\)\(.*\)/\1="\2"/' >/tmp/t$$
   chmod +x /tmp/t$$
   . /tmp/t$$
else
   #
   # This else section is for LPRng, which includes Caldera, RedHat >= 7.0,
   # and SuSE 7.3 
   #
   # LPRng no longer uses a lock file. In order to not break old platforms
   # we included this else section.  We use the '-C' flag to pass command line 
   # options. This works fine, but if you do not pass a command line -C option,
   # the 'C' variable is set to 'A' which is set to the hostname variable.  So, 
   # I check to see if the C variable includes lexopts.  If it does not, I unset 
   # the variable C in order for it not to be used as a hostname
   #     
   if [ "$DEBUG" = 1 ] ; then cat $FILE  >> /tmp/FILE ; fi
   cat "$FILE" | sed -e 's/^\(.\)\(.*\)/\1="\2"/' >/tmp/t$$
   chmod +x /tmp/t$$
   . /tmp/t$$
   echo "${C}" | grep -E "lexopts|lexopt|lexformat|lexfmt" > /dev/null
   if [ "$?" != "0" ]; then
      if [ "${DEBUG}" = "1" ];then
                {
                echo
                echo "Found the [ -C ] flag, but did not see our key [ lexopts ]"
                echo "The correct command line would be [ -C \"lexopt:tag_value tag_value\" ]"
                echo
                }  >> /tmp/marknet_filter.debug$$
      fi
      unset C
   fi
fi 

if [ "${DEBUG}" = "1" ]
then
	echo "*** Start cf file contents" >> /tmp/marknet_filter.debug$$
	cat /tmp/t$$ >> /tmp/marknet_filter.debug$$
	echo "*** End cf file contents" >> /tmp/marknet_filter.debug$$
fi

# Set username ( use literal or person)
if [ -n "$L" ] ; then
	username="$L"
else
	if [ -n "$P" ] ; then
		username="$P"
	else
		username="$user"
	fi
fi

option_list=""
hostname=""
# Get Lexmark formatter options or hostname from the CF's Classification field
if [ -n "$C" ] ; then
	key=`echo "$C" | (IFS=":" read p1 foo; echo $p1)`
        if [ "$key" = "lexformat" -o "$key" = "lexfmt" -o \
	     "$key" = "lexopt" -o "$key" = "lexopts" ] ; then
		if [ "$DEBUG" = 1 ] ; then echo "*** recognized lexformat key '${key}:'" >> /tmp/marknet_filter.debug$$ ; fi
                option_list=`echo "$C" | (IFS=":" read p1 rest; echo $rest)`
                if [ "$DEBUG" = 1 ] ; then echo "*** option_list = '$option_list'" >> /tmp/marknet_filter.debug$$ ; fi
        else
                hostname="$C"
        fi
fi
# If still no hostname, get it from the CF's Host field or the -h flag
if [ -z "$hostname" ] ; then
        if [ -n "$H" ] ; then
                hostname="$H"
        else
                hostname="$host"
        fi
fi

# Set jobname ( use jobname or filename)
if [ -n "$J" ] ; then
	jobname=`basename $J`
else
	if [ -n "$N" ] ; then
		jobname=`basename $N`
	else
		jobname="unknown"
	fi
fi

#
# Make the expression to transport the data to the printer
#

TRANS="|`${APPLICATION_DIR}/bin/${BUILD_TRANSPORT_CMD} -q "${printer}" -h "$hostname" -u "$username" -j "$jobname"`"

#
# Evaluate the whole expression and check the return code
#

if [ "${DEBUG}" = "1" ] ; then
	echo "TRANS=$TRANS" >> /tmp/marknet_filter.debug$$
fi

if [ -f "$LPRng_control_file" ] ; then
   spool_tmp=`dirname $LPRng_control_file`/marknet.$$
   umask 277
   cat >$spool_tmp
   eval "run_first <$spool_tmp $TRANS"
   rm -f $spool_tmp
else
   eval "run_first $TRANS"
fi

cleanup
exit 0
