#!/bin/sh
########################################################################
#             (c) Copyright 2004 Lexmark International, Inc.           #
#                        All rights reserved                           #
########################################################################
#                                                                      #
# This command shows the license agreement.                            #
#                                                                      #
########################################################################

DEBUG=0
show_text="yes"


PRODUCT_LINK="/usr/genprint"
SCRIPTS_DIR="${PRODUCT_LINK}/bin/.scripts"

#-- load the shared script
. ${SCRIPTS_DIR}/shared

#-- initialize variables:
initialize user

is_privileged_user >> /dev/null 2>&1 
if [ "$?" = "0" ];then
   USER_TYPE="admin"
else
   USER_TYPE="user"
fi

#-- usage text
usage ()
{
${CAT_CMD} << EOT

license_agreement
	Allows the viewing and accepting the license agreement.

USAGE:
	license_agreement [accept] [-x]
	license_agreement [-h]

OPTIONS:
	accept
		Allows the accepting of the license agreement without it 
		being shown.  This is for automation purposes only.

	-x
		Run license_agreement in debug mode.

EOT
}


while [ ! -z "${1}" ]
do
	case "${1}" in

		-x) 
			DEBUG=1
			;;

		accept)
			show_text="no"
			;;

		*)
			usage
			exit 99
			;;
	esac
	shift 1
done

if 	[ "${show_text}" = "yes" ];then 
		license_agreement "${USER_TYPE}" "show_text"
else
		license_agreement "${USER_TYPE}" "noshow"
fi

${PRINT_CMD} "License Agreement has been accepted."

exit 0
