#!/bin/sh


PKG="$PKG"
INSTDIR="$BINDIR"

PROGRAM_NAME="Print Drivers"
INSTALL_DIR="/usr/genprint"
APP=genprint
APP_SPOOL=printer/unix_prt_drivers
SYS_SPOOL="/var/spool"

LS_CMD="/bin/ls"
EGREP_CMD="/bin/egrep"
GREP_CMD="/bin/grep"
CHMOD_CMD="/bin/chmod"
MKDIR_CMD="/bin/mkdir"
TOUCH_CMD="/bin/touch"
RM_CMD="/bin/rm"
CHGRP_CMD="/bin/chgrp"
ECHO_CMD="/bin/echo"
PRINTF_CMD="/usr/bin/printf"
SED_CMD="/bin/sed"
CAT_CMD="/bin/cat"
CHOWN_CMD="/bin/chown"
FIND_CMD="/usr/bin/find"
TR_CMD="/usr/bin/tr"
CP_CMD="/bin/cp"
RM_CMD="/bin/rm"
EXPR_CMD="/usr/bin/expr"
DATE_CMD="/bin/date"
if [ -x "/bin/awk" ];then      AWK_CMD="/bin/awk"           ; else AWK_CMD="/usr/bin/awk"           ; fi
if [ -x "/bin/basename" ];then BASENAME_CMD="/bin/basename" ; else BASENAME_CMD="/usr/bin/basename" ; fi
if [ -x "/usr/bin/id" ];then   ID_CMD="/usr/bin/id"         ; else ID_CMD="/bin/id"                 ; fi

ASIAN="Asian"
DIR_PERM=755
FILE_PERM=644 
ROOT=printer
RESTART_CUPSD="NO"

VIR_QUEUES_DIR="${SYS_SPOOL}/${APP_SPOOL}/vir_queues"
PROP_DIR="${SYS_SPOOL}/${APP_SPOOL}/.${APP}/props"
PROP_FILE="${SYS_SPOOL}/${APP_SPOOL}/.${APP}/props/app.properties"
BROWSER_LINK="${INSTALL_DIR}/bin/browser"
VIR_QUEUES_DIR="${SYS_SPOOL}/${APP_SPOOL}/vir_queues"

known_paths="/usr/dt/bin/netscape
		/opt/NSCPcom/netscape 
		/usr/bin/netscape 
		/usr/X11R6/bin/netscape
		/usr/X11R6/bin/netscape6
		/usr/bin/konqueror
		/opt/kde3/bin/konqueror
		/usr/bin/mozilla
		/usr/sfw/bin/mozilla
		/usr/X11R6/bin/mozilla
		/usr/bin/galeon
		/usr/bin/firefox
		/opt/firefox/firefox
		/opt/gnome/bin/galeon"


LANG=C
LC_ALL=C
export LANG 
export LC_ALL

is_privileged_user()
{
	id="`${ID_CMD}`"
	${PRINTF_CMD} "${id}" | ${EGREP_CMD} "^uid=0">/dev/null 2>&1
	if [ ${?} -ne 0 ]; then
		${ECHO_CMD} "You must be an administrative user to run $0!"
		exit 1
	fi
}

is_privileged_user

#---------------------------------------------------
#--  check_userid
#--
#--  This function verifies a userid
#--
#--  Syntax:

manage_dir_permissions() 
{
	absolute_path="${1}"
	permissions="${2}"

	if [ -d "${absolute_path}" ]; then
		#-- ${ECHO_CMD} "   ${absolute_path}  exists... OK"
		${CHMOD_CMD} ${permissions} ${absolute_path}
	else
		#-- ${ECHO_CMD} "   creating ${absolute_path} ... OK"
		${MKDIR_CMD} -p ${absolute_path}
		${CHMOD_CMD} ${permissions} ${absolute_path}
	fi
}

get_value() 
{
	OPTION="${1}"
	value="NOT_SET"
	return_code=1

	if [ -f "${PROP_FILE}" ];then
		value=`${GREP_CMD} "${1}" ${PROP_FILE} 2>/dev/null | ${SED_CMD} -e "s/${1}=//g" | ${SED_CMD} 1q`
		if [ ! -z "${value}" ] ;then
			return_code=0
		fi
	fi
	${ECHO_CMD} ${value}
	return ${return_code}
}

remove_line() 
{
	continue="yes"
	if [ -f "${PROP_FILE}" ];then
		while [ "${continue}" = "yes" ]
		do
      	line_no=`${GREP_CMD} -n "${1}" ${PROP_FILE} | ${AWK_CMD} -F":" '{print $1}' | ${SED_CMD} 1q`
			if [ ! -z "${line_no}" ];then
				${CAT_CMD} ${PROP_FILE} | ${SED_CMD} ${line_no}d > ${PROP_FILE}.$$
				${CP_CMD} -f ${PROP_FILE}.$$ ${PROP_FILE}
				${CHMOD_CMD} 644 ${PROP_FILE} ${PROP_FILE}.$$
				${RM_CMD} -f ${PROP_FILE}.$$
			else
				continue="no"
			fi
		done
	fi
}

update_prop_file()
{
	TAG="${1}"
	VALUE="${2}"
	remove_line "${TAG}"

	if [ ! -d "${PROP_DIR}" ];then
		${MKDIR_CMD} -p ${PROP_DIR}
	fi

	${ECHO_CMD} "${TAG}=${VALUE}" >> ${PROP_FILE} 2>/dev/null
	RC1=${?}

	${CHMOD_CMD} ${FILE_PERM} ${PROP_FILE} >/dev/null 2>&1
	RC2=${?}

	if [ "${RC1}" != "0" -o "${RC2}" != "0" ]; then
		${ECHO_CMD} "ERROR:  Failed to update app.properties."
	fi
}

check_group() 
{
	TEST_FILE="/tmp/testfile.groups$$"
	group="${1}"

	if [ ! -z "${group}" ];then
		${TOUCH_CMD} ${TEST_FILE}
		${CHGRP_CMD} ${group} ${TEST_FILE} >/dev/null 2>&1
		RC=$?
		${RM_CMD} -f ${TEST_FILE} >/dev/null 2>&1 

		if [ "${RC}" != "0" ]; then
			${PRINTF_CMD} "Group [ ${group} ] is not a valid group.\n" >&2
			return_code=1
		else
			#-- ${ECHO_CMD} "Group [ ${group} ] is a valid group!"
			return_code=0
		fi
		return ${return_code}
	fi
}

list_default_group()
{
	check_group "admin" 2>/dev/null
	if [ $? -eq 0 ];then
		${ECHO_CMD} "admin"
	else
		${ECHO_CMD} "bin"
	fi
}

show_message()
{
	if [ "${INTERACTIVE}" = "NO" ];then
		${ECHO_CMD} "${1}"
	fi
}

set_group() 
{
	DEF_GROUP="`list_default_group`"
	if [ -z "${1}" ];then
		${ECHO_CMD}
		${ECHO_CMD} "This application is a suid root program, which allows the" 
		${ECHO_CMD} "root user or members of the administrative group to have"
		${ECHO_CMD} "administrative privileges. These privileges include adding,"
		${ECHO_CMD} "removing, and modifying printer queues." 
		${ECHO_CMD}
		${ECHO_CMD} "To set the administrative group, select any valid group."
		${ECHO_CMD} "The default is ( ${DEF_GROUP} )."
		${ECHO_CMD}

		continue=yes
	
		app_group="`get_value app.group`"
		if [ "${?}" = "0" ];then
			GROUP="${app_group}"
		else
			GROUP="${DEF_GROUP}"
		fi
	
		while [ "${continue}" = "yes" ]
		do
			${PRINTF_CMD} "Enter an administrative group ( ${GROUP} ): "
			read mvgroup
			if [ -z "${mvgroup}" ]; then
				mvgroup="${GROUP}"
			fi
			check_group ${mvgroup}
			if [ "${?}" = "0" ];then
				continue=no
			fi
		done
	else
		mvgroup=${1}
		check_group ${mvgroup} 
		if [ "${?}" != "0" ];then
			setup_incomplete
			exit 1
		fi
	fi

	# ${FIND_CMD} ${INSTALL_DIR}/bin -perm /u+s -print 2>&1 | ${GREP_CMD} "invalid mode" >/dev/null 2>&1
	# if [ $? -eq 0 ];then
	# 	OWNER_FIND_ARG="+u+s"
	# 	GROUP_FIND_ARG="+g+s"
	# else
	# 	OWNER_FIND_ARG="/u+s"
	# 	GROUP_FIND_ARG="/g+s"
	# fi
	OWNER_FIND_ARG="-u+s"
	GROUP_FIND_ARG="-g+s"
	setuids=`${FIND_CMD} ${INSTALL_DIR}/bin -perm ${OWNER_FIND_ARG} -print 2>/dev/null`
	setgids=`${FIND_CMD} ${INSTALL_DIR}/bin -perm ${GROUP_FIND_ARG} -print 2>/dev/null`
	if [ -n "${mvgroup}" ] ; then
		${CHGRP_CMD} ${mvgroup} ${INSTALL_DIR}/bin/* >/dev/null 2>&1
	fi
	if [ -n "${setuids}" ]; then
		${CHMOD_CMD} u+s ${setuids}
	fi
	if [ -n "${setgids}" ]; then
		${CHMOD_CMD} g+s ${setgids}
	fi

	#-- Update the props file
	update_prop_file "app.group" "${mvgroup}"
	show_message "Administrative Group : ${mvgroup}"
}



mk_spool_dirs()
{
	#-- ${ECHO_CMD}
	#-- ${ECHO_CMD} "Checking your spool directories:"
	#-- ${ECHO_CMD}
	manage_dir_permissions ${SYS_SPOOL}/${ROOT} ${DIR_PERM} 
	manage_dir_permissions ${SYS_SPOOL}/${APP_SPOOL} ${DIR_PERM} 
	manage_dir_permissions ${SYS_SPOOL}/${APP_SPOOL}/.${APP} ${DIR_PERM} 
	manage_dir_permissions ${SYS_SPOOL}/${APP_SPOOL}/.${APP}/props ${DIR_PERM} 

	DIRS="vir_devices vir_queues"
	for dir in $DIRS
	do
		manage_dir_permissions ${SYS_SPOOL}/${APP_SPOOL}/${dir} ${DIR_PERM} 
		${CHOWN_CMD} lp:lp ${SYS_SPOOL}/${APP_SPOOL}/${dir}
	done

	if [ -d "${INSTALL_DIR}/${PDD_DIR}" ]; then
		#-- ${ECHO_CMD} 
		#-- ${ECHO_CMD} "Setting PDD permissions." 
		#-- ${ECHO_CMD} 
		${CHGRP_CMD} lp ${INSTALL_DIR}/${PDD_DIR}
		${CHGRP_CMD} lp ${INSTALL_DIR}/${PDD_DIR}/*
	fi

	if [ ! -f "/var/log/lpd-vpd.log" ];then
		${TOUCH_CMD} /var/log/lpd-vpd.log >/dev/null 2>&1
	fi

}

setup_done () 
{
   ${PRINTF_CMD} "Setup complete!\n\n"
}

set_paper_size2() 
{
   	paper_size="${1}"
		${ECHO_CMD} "${paper_size}" | ${EGREP_CMD} -i "LETTER|A4" >/dev/null 2>&1
		if [ "${?}" != "0" ];then
			${ECHO_CMD} "Invalid paper size ${paper_size}, defaulting to letter."
			paper_size="LETTER"
		fi
		paper_size="`${ECHO_CMD} ${paper_size} | ${TR_CMD} '[:upper:]' '[:lower:]'`"
		case ${paper_size} in 
				letter) paper_size="ltr" ;;
				a4) paper_size="a4" ;;
				 *) paper_size="ltr" ;;
		esac
		update_prop_file "app.papersize" "${paper_size}"
		show_message "Paper Size           : `${ECHO_CMD} ${paper_size} | ${SED_CMD} -e 's/ltr/letter/g'`"

}


set_paper_size()
{
	NUM="1"
	app_papersize=`get_value app.papersize`
	if [ "${app_papersize}" = "a4" ];then
		NUM="2"
	fi

	loop="yes"
	${ECHO_CMD} "Default paper size selection."
	${ECHO_CMD}
	${ECHO_CMD} " 1.  Letter (default)"
	${ECHO_CMD} " 2.  A4"
	${ECHO_CMD}

	while [ "${loop}" != "no" ]
	do
		${PRINTF_CMD} "Enter your choice : [${NUM}] "
		read size_ans
		if [ "${size_ans}" = "" ];then
			size_ans="${NUM}"
		fi
		if [ "${size_ans}" != "1" -a "${size_ans}" != "2" ];then
			${PRINTF_CMD} "Invalid Selection!"
			continue
		else
			loop="no"
		fi
	done

	if [ "${size_ans}" = "2" ];then
		paper_size=a4
	else
		paper_size=ltr
	fi

	update_prop_file "app.papersize" "${paper_size}"
}

which_subsystem()
{
	loop="yes"

	${ECHO_CMD} "Print Subsystem Selection."
	${ECHO_CMD}
	${ECHO_CMD} "  1.  Line Printer Daemon (LPD)"
	${ECHO_CMD} "  2.  Common UNIX Printing System (CUPSD)"
	${ECHO_CMD} 

	while [ "${loop}" != "no" ]
	do
		${PRINTF_CMD} "Enter your choice : "
		read answer
		if [ "${answer}" != "1" -a "${answer}" != "2" ];then
			${PRINTF_CMD} "Invalid Selection!"
			continue
		else
			loop="no"
		fi
	done

	if [ "${answer}" = "1" ];then
		return 0
	else 
		return 1
	fi
}

is_cups() 
{
	if [ -f "${INSTALL_DIR}/bin/.scripts/print_daemon.sh" ];then
		#-- print_daemon.sh exists with 1 or 2 if its cups
		${INSTALL_DIR}/bin/.scripts/print_daemon.sh >/dev/null 2>&1
		RC=${?}
		if [ "${RC}" = "1" -o "${RC}" = "2" ];then
			file1="/etc/cups/mime.types"
			if [ ! -f "${file1}" ];then
				# -- If this file does not exist, just exit.
				return 0
			else
				${ECHO_CMD} cups
				${GREP_CMD} "#---CMT---# application/vnd.cups-raw" ${file1} >/dev/null 2>&1
				if [ ${?} -eq 0 ];then
					${ECHO_CMD} enable	
				else
					${ECHO_CMD} disable	
				fi
				return ${RC}
			fi
		fi
	fi
	return 0
}

set_print_subsystem()
{
	${INSTALL_DIR}/bin/.scripts/print_daemon.sh >/dev/null 2>&1
	sRC=${?}
	case ${sRC} in
		0) SUBSYSTEM="bsd"  ;; 
		1) SUBSYSTEM="cups" ;; 
		2) SUBSYSTEM="cups" ;; 
		3) SUBSYSTEM="bsd"  ;; 
		4|5) which_subsystem  
			if [ $? -eq 0 ];then
				SUBSYSTEM="bsd"
			else
				SUBSYSTEM="cups"
			fi
			;;
	esac
	update_prop_file "app.prt_subsystem" "${SUBSYSTEM}"

	if [ "${SUBSYSTEM}" = "cups" ];then
		${ECHO_CMD} "Enabling CUPS print support"
		update_interface_owner
		update_cups_mime
	else
		${ECHO_CMD} "Enabling LPD print support"
	fi
}

add_mime_comment()
{
	if [ ! -f "${file2}" ];then
		${CP_CMD} ${file1} ${file2}
	fi
	${CP_CMD} ${file1} ${tmpfile}
	${CAT_CMD} ${tmpfile} | ${AWK_CMD} ' BEGIN { PRINT_LINE=0 }
                     /application\/vnd.cups-raw/ { PRINT_LINE=1 }
                     {
                         if ( PRINT_LINE == 1 ) {
                            if ( /[^\\]$/ ) { PRINT_LINE=0 }
                            if ( /^$/ )     { PRINT_LINE=0 }
                            print "#---CMT---# " $0
                         }
                         else
                         {
                            print
                         }
                     }
                     ' > ${file1}
	${CHMOD_CMD} ${FILE_PERM} ${file1}
	${RM_CMD} ${tmpfile}
}

restart_cups()
{
	answer="n"
	answer_accepted="no"

	#-- Check to see if we need to restart cups
	${INSTALL_DIR}/bin/.scripts/print_daemon.sh >/dev/null 2>&1
	if [ ${?} -ne 1 ];then
		return
	fi

	#-- This fixes issue I have seen when running cupsd from this script.
	PATH=/sbin:/usr/sbin:$PATH ; export PATH

	if [ "${INTERACTIVE}" = "YES" ];then 
		${ECHO_CMD} 
		${ECHO_CMD} "In-order for this change to occur, we need to restart CUPS."
		while  [ "${answer_accepted}" = "no" ]
		do
			${PRINTF_CMD} "Restart CUPS now (y|n)? : [y] " 
			read answer
			if [ "${answer}" = "y" ] || [ -z "${answer}" ] || [ "${answer}" = "n" ];then
				answer_accepted="yes"
			fi
		done
	fi

	if [ "${answer}" = "y" ] || [ -z "${answer}" ];then
		RESTART_CUPSD="YES"
	fi

	if [ "${RESTART_CUPSD}" = "YES" ];then
		show_message "Restart cupsd        : yes"
		if [ -f /etc/init.d/cupsys ];then
			/etc/init.d/cupsys restart
		else
			/etc/init.d/cups restart
		fi
	else
		show_message "Restart cupsd        : no"
		${ECHO_CMD} "Changes will not occur until cupsd is restarted."
	fi
}

update_interface_owner()
{
	if [ -f /etc/SuSE-release ];then
		VERSION="`${CAT_CMD} /etc/SuSE-release | ${SED_CMD} 1q | ${AWK_CMD} '{print $3}'`"
		${EXPR_CMD} ${VERSION} \>= 9.0 >/dev/null 2>&1
		if [ $? -eq 0 ];then
			fileperms=`${LS_CMD} -ld /etc/cups/interfaces 2>&1`
			if [ $? -eq 0 ];then
				${ECHO_CMD} ${fileperms} | ${AWK_CMD} '{print $3}' | ${GREP_CMD} "root" >/dev/null 2>&1
				if [ $? -eq 0 ];then
					${CHOWN_CMD} lp /etc/cups/interfaces
				fi
			fi
		fi
	fi

	if [ -f /etc/debian_version -a -f /etc/lsb-release ];then
		${CAT_CMD} /etc/lsb-release | ${GREP_CMD} -i ubuntu >/dev/null 2>&1
		RC1=${?}
		${CAT_CMD} /etc/lsb-release | ${GREP_CMD} -i spire >/dev/null 2>&1
		RC2=${?}

		if [ "${RC1}" -eq "0" -o "${RC2}" -eq "0" ]; then
			fileperms=`${LS_CMD} -ld /etc/cups/ppd 2>&1`
			if [ $? -eq 0 ];then
				${ECHO_CMD} $fileperms | ${AWK_CMD} '{print $3}' | ${GREP_CMD} cupsys >/dev/null 2>&1
				if [ $? -eq 0 ];then
					${LS_CMD} -ld /etc/cups/interfaces 2>/dev/null | ${AWK_CMD} '{print $3}' | ${GREP_CMD} root >/dev/null 2>&1
					if [ $? -eq 0 ];then
						${ECHO_CMD} "Changing the owner of the (/etc/cups/interfaces) directory to cupsys."
						${CHOWN_CMD} cupsys /etc/cups/interfaces
					fi
				fi
			fi
		fi
	fi
}

update_cups_mime()
{
	file1="/etc/cups/mime.types"
	file2="/etc/cups/mime.types.${APP}"
	tmpfile=/tmp/lexprint.$$
	answer_accepted="no"

	#-- Check for original mime.type file
	if [ ! -f "${file1}" ];then
		return 
	fi

	#-- Check to see if vnd.cups-raw is defined.
	${EGREP_CMD} "application/vnd.cups-raw" ${file1} >/dev/null 2>&1
	if [ $? -ne 0 ];then
		return
	fi 
	
	if [ "${INTERACTIVE}" = "YES" ];then
		${ECHO_CMD}
		${ECHO_CMD} "The Common UNIX Print Subsystem (CUPS) uses mime.types to determine"
		${ECHO_CMD} "how to filter print jobs.  One of the mime types is defined as"
		${ECHO_CMD} "[ application/vnd.cups-raw ], which causes PCL emulation print jobs to by-pass"
		${ECHO_CMD} "the print filters.  This define needs to be commented out so that PCL emulation"
		${ECHO_CMD} "print jobs are passed through the print filters."
		${ECHO_CMD} 
	elif [ -z "${CUPSD}" ];then
			return
	fi

	#-- Check to see if vnd.cups-raw is commented out.
	${EGREP_CMD} "^ *application/vnd.cups-raw" ${file1} >/dev/null 2>&1
	if [ $? -eq 0 ];then
		if [ "${INTERACTIVE}" = "YES" ];then
			while [ "${answer_accepted}" = "no" ]
			do
				${PRINTF_CMD} "Would you like for us to make this change? (y|n) : [y] "
				read answer
				if [ "${answer}" = "y" ] || [ -z "${answer}" ] || [ "${answer}" = "n" ];then
					answer_accepted="yes"
				fi
			done

			if [ "${answer}" != "y" ] && [ ! -z "${answer}" ];then
				${ECHO_CMD}
				${ECHO_CMD} "You chose not to make this change."
				${ECHO_CMD} "Note: This may affect the printing of certain print jobs." 
				${ECHO_CMD}
				return
			else
				CUPSD="enable"
			fi
		fi

		if [ "${CUPSD}" = "enable" ]; then
			show_message "Enable PCL Emulation Job Filtering"
			add_mime_comment
			restart_cups
		fi
      return
	fi

	${GREP_CMD} "#---CMT---# application/vnd.cups-raw"  ${file1} >/dev/null 2>&1
	if [ $? -eq 0 ];then
		if [ "${INTERACTIVE}" = "YES" ];then
			${ECHO_CMD} "We have determined that we have already commented out this define."
			${ECHO_CMD} 
			while [ "${answer_accepted}" = "no" ]
			do
				${PRINTF_CMD} "Do you want to restore this define? (y|n) : [n] " 
				read answer
				if [ "${answer}" = "y" ] || [ -z "${answer}" ] || [ "${answer}" = "n" ];then
					answer_accepted="yes"
				fi
			done
			${ECHO_CMD} 
		fi

		if [ "${answer}" = "y" ];then
			CUPSD="disable"
		fi

		if [ "${CUPSD}" = "disable" ] ;then
			#-- lexprint will not work correctly with this settings.
			show_message "Disable PCL Emulation Job Filtering"
			${CP_CMD} ${file1} ${tmpfile}
			${CAT_CMD} ${tmpfile} | ${SED_CMD} -e 's/#---CMT---# //g' > ${file1}
			${RM_CMD} ${tmpfile}
			restart_cups
		fi
	fi
}

set_install_date()
{
	if [ ! -f "${SYS_SPOOL}/${APP_SPOOL}/.${APP}/props/gen.properties" ];then
		DATE_STRING=`${DATE_CMD} +%m%d%y%H%M%S`
		${ECHO_CMD} "gen.installed.date=${DATE_STRING}"   > ${SYS_SPOOL}/${APP_SPOOL}/.${APP}/props/gen.properties
		${ECHO_CMD} "gen.unique.user.dir=${DATE_STRING}" >> ${SYS_SPOOL}/${APP_SPOOL}/.${APP}/props/gen.properties
	fi
	${CHMOD_CMD} ${FILE_PERM} ${SYS_SPOOL}/${APP_SPOOL}/.${APP}/props/gen.properties
}

check_for_asian_queues()
{
	qFound="no"
	
	if [ ! -d "${VIR_QUEUES_DIR}" ];then
		return 0
	fi

	cd ${VIR_QUEUES_DIR}
	for queue in `${LS_CMD}`
	do
		if [ -f "${queue}/.${queue}" ];then
			${EGREP_CMD} "${ASIAN}" ${queue}/.${queue} >/dev/null 2>&1
			if [ $? -eq 0 ];then
				qFound="yes"
				if [ -z "${qFoundList}" ];then
					qFoundList="${queue}"
				else
					qFoundList="${qFoundList}, ${queue}"
				fi
			fi
		fi
	done

	if [ "${qFound}" = "yes" ];then
		if [ "${INTERACTIVE}" = "NO" ];then
			${ECHO_CMD} "${qFoundList}"
		else
			${ECHO_CMD} 
			${ECHO_CMD} "Disabling Asian driver support failed.  There are queues"
			${ECHO_CMD} "associated with this feature and they must be removed"
			${ECHO_CMD} "before this feature can be disabled."
			${ECHO_CMD} 
			${ECHO_CMD} "QUEUES: ${qFoundList}" 
			${ECHO_CMD} 
		fi
		return 1
	fi
	return 0
}

check_asian_queues() 
{
	asian_support="${1}"

	if [ "${asian_support}" != "yes" -a "${asian_support}" != "no" ];then
		${ECHO_CMD} "Invalid -A option [ ${asian_support} ].  Valid options are yes or no." 
		return 0
	fi
	if [ "${asian_support}" = "no" ];then
		check_for_asian_queues
		return ${?}
	fi
	return 0
}

set_enable_asian2()
{
	asian="${1}"
	if [ ! -z "${asian}" ];then
		asian="`${ECHO_CMD} ${asian} | ${TR_CMD} '[:upper:]' '[:lower:]'`"
		case ${asian} in 
			yes|no)
				;;
			*)
				${PRINTF_CMD} "\nInvalid option [ ${asian} ] for -a\n"
				exit 1
				;;
		esac
		update_prop_file "enable_asian" "${asian}"
		if [ "${asian}" = "yes" ];then
			show_message "Enable Asian Drivers"
		else
			show_message "Disable Asian Drivers"
		fi
   fi
}

#-- Code for enabling and disabling asian language support
set_enable_asian()
{
	NUM="1"
	AQExist=0
	enable_asian="`get_value enable_asian`"
	if [ "${enable_asian}" = "yes" ];then
		NUM="2"
	fi

	loop="yes"
	${ECHO_CMD} "Asian Driver Support"
	${ECHO_CMD} 
	${ECHO_CMD} "Enabling Asian Driver support provides users with additional Asian"
	${ECHO_CMD} "printing options, such as printing with and without the Asian Font"
	${ECHO_CMD} "DIMM.  You can access these features from the driver properties"
	${ECHO_CMD} "font tab."   
	${ECHO_CMD}
	${ECHO_CMD} "In-order to take advantage of these features, you must enable this"
	${ECHO_CMD} "option and create a printer queue with Asian in the model name."
	${ECHO_CMD}
	${ECHO_CMD} "Do you want to enable Asian driver support?"
	${ECHO_CMD}
	${ECHO_CMD} " 1.  Disable (default)"
	${ECHO_CMD} " 2.  Enable"
	${ECHO_CMD}
	while [ "${loop}" != "no" ]
	do
		${PRINTF_CMD} "Enter your choice : [${NUM}] "
		read asian
		if [ "${asian}" != "1" -a "${asian}" != "2" -a "${asian}" != "" ];then
			${PRINF_CMD} "Invalid Selection!"
			continue
		else
			loop="no"
		fi
	done

	if [ "${asian}" = "" ];then
 		asian="${NUM}"
	fi
	if [ "${asian}" = "1" ];then
		asian="no"
		check_for_asian_queues
		AQExist=${?}
	elif [ "${asian}" = "2" ];then
		asian="yes"
	fi

	if [ "${AQExist}" = "0" ];then 
		update_prop_file "enable_asian" "${asian}"
	else
		update_prop_file "enable_asian" "yes"
	fi
}


show_only_gnome()
{
	#-- If OS matches here, we will only show gnome menu utility, so that we don't end up with two links.
   #-- Both KDE & GNOME look in the same locations for menus.
	if [ -f "/etc/fedora-release" -o -f "/etc/SuSE-release" -o -f "/etc/redhat-release" -o -f "/etc/debian_version" ];then
		return 1
	else	
		return 0
	fi
}

#-- list all available menus
list_menus() 
{
	MENU=""
	if [ -f "/usr/bin/gnome-wm" -o -f "/opt/gnome/bin/gnome-wm" -o -f "/opt/gnome2/bin/gnome-wm" ];then
		MENU="${MENU}:gnome"
		show_only_gnome
		if [ $? -eq 1 ];then
			MENU="${MENU}:gnomeOnly"
			${ECHO_CMD} ${MENU} | ${SED_CMD} -e 's/^://g'
			exit 0
		fi 
	fi

	if [ -f "/usr/bin/kdesktop" -o -f "/opt/kde3/bin/kdesktop" -o -f "/usr/lib/kde3/bin/kdesktop" ];then
		MENU="${MENU}:kde"
	fi

	if [ -x /usr/dt/bin/dtlogin ]; then
		MENU="${MENU}:cde" 
	fi

	${ECHO_CMD} ${MENU} | ${SED_CMD} -e 's/^://g'
	exit 0
}


kde_gnome_main()
{
	if [ -f "/usr/bin/gnome-wm" -o -f "/opt/gnome/bin/gnome-wm" -o -f "/opt/gnome2/bin/gnome-wm" ];then
		#-- Manage the GNOME Menu
		show_separator
		show_only_gnome
		if [ $? -eq 0 ];then
			${INSTALL_DIR}/bin/gnome_menu_utility.sh
		else
			${INSTALL_DIR}/bin/gnome_menu_utility.sh -n
			return
		fi
	fi

	if [ -f "/usr/bin/kdesktop" -o -f "/opt/kde3/bin/kdesktop" -o -f "/usr/lib/kde3/bin/kdesktop" ];then
		#-- Manage the KDE Menu
		show_separator
		${INSTALL_DIR}/bin/kde_menu_utility.sh
	fi
}

linuxver()
{
	#-- Setup Linux Environment
	show_separator
	${INSTALL_DIR}/bin/linux_version.sh
	show_separator
}


list_browser() 
{
	STR=""
	for path in ${known_paths}
	do
		if [ ! -x "${path}" ];then
			continue
		fi
		STR="${STR}:${path}" 
	done
	${ECHO_CMD} ${STR} | ${SED_CMD} -e 's/^://g'
}

set_browser2() 
{
	file="${1}"

	${ECHO_CMD} ${file} | ${EGREP_CMD} -i "^none$" >/dev/null 2>&1
	if [ $? -eq 0 ];then
		file="None"
	fi
	if [ "${file}" = "None" ];then
		${RM_CMD} -f ${BROWSER_LINK}
		remove_line "app.browser"
		show_message "Web Browser          : None"
		return
	fi

	if [ -x "${file}" -a -f "${file}" ];then
		if [ -f "${BROWSER_LINK}" ];then
			${RM_CMD} -f ${BROWSER_LINK}
		fi
		${ECHO_CMD} "#!/bin/sh" > ${BROWSER_LINK}
		${ECHO_CMD} " "         >> ${BROWSER_LINK}
		${ECHO_CMD} ${file} \$* >> ${BROWSER_LINK}

		${CHMOD_CMD} 755 ${BROWSER_LINK}

		update_prop_file "app.browser" "${file}"
		show_message "Web Browser          : ${file}"
	else
		${ECHO_CMD} "Browser ${file} does not exist."
		setup_incomplete
	fi
}

set_browser()
{
	COUNT=1

	app_browser=`get_value app.browser`

	${ECHO_CMD}
	${ECHO_CMD} "${PROGRAM_NAME} Help System consists of html files."
	${ECHO_CMD} "To be able to view these html help files, we need the"
	${ECHO_CMD} "absolute path to a valid \"Web Browser\"."
	${ECHO_CMD}
	for path in ${known_paths}
	do
		if [ ! -x "${path}" ];then
			continue
		fi
		${ECHO_CMD} "${COUNT}. ${path}"
		eval browsers_${COUNT}="${path}"
		if [ "${app_browser}" = "${path}" ];then
			DEFAULT=${COUNT}
		fi
		COUNT=`expr $COUNT + 1`
	done
	${ECHO_CMD} "${COUNT}. Specify a web browser."
	BROWSER_NUM=${COUNT}

   #-- Provide a none option.
   COUNT=`expr $COUNT + 1`
   ${ECHO_CMD} "${COUNT}. None."
   ${ECHO_CMD}

   browser_setup="no"
	if [ -z "${DEFAULT}" ];then
		DEFAULT=${COUNT}
	fi

   while [ "${browser_setup}" = "no" ]
   do
      ${PRINTF_CMD} "Enter your choice : [${DEFAULT}] "
      read answer

      #-- Check for blank or default value
      ${ECHO_CMD} "${answer}" | ${EGREP_CMD} "  *" >/dev/null 2>&1
      if [ "${?}" = "0" ] || [ -z "${answer}" ];then
         answer=${COUNT}
      fi
      #-- Make sure answer is a number.
      ${ECHO_CMD} "${answer}" | ${EGREP_CMD} "^[0-9][0-9]*$" >/dev/null 2>&1
      if [ "${?}" != "0" ];then
         ${PRINTF_CMD} "Invalid Selection! "
         continue
      fi

      #-- Make sure answer is a valid option.
      if [ ${answer} -le 0 -o ${answer} -gt ${COUNT} ];then
         ${PRINTF_CMD} "Invalid Selection! "
         continue
      else 
         if   [ ${answer} -eq ${COUNT} ];then
              #-- Selected None
              skip_browser_setup="yes"
              browser_setup="yes"
         elif [ ${answer} -eq ${BROWSER_NUM} ];then
              #-- Selected Specify a Web Browser path
              ${PRINTF_CMD} "Enter absolute path to web browser : "
              read file
              if [ -x "${file}" ];then
                 browser_setup="yes"
              else
                 unset file
                 ${PRINTF_CMD} "Invalid File! "
              fi    
         else
              browser_setup="yes"
         fi 
      fi
   done

   if [ "${skip_browser_setup}" != "yes" ];then
      if [ -z "${file}" ];then
         eval file=$`${ECHO_CMD} browsers_${answer}`
      fi
	else
		file="None"
   fi
	set_browser2 "${file}"
}

show_separator ()
{
   ${ECHO_CMD} "---------------------------------------------------"
}

#-- usage_short text
usage_short()
{
FNAME=`${BASENAME_CMD} ${0}`
${CAT_CMD} << EOT

USAGE:
    ${FNAME} -a asian_support -b browser -g group -p paper_size \\
                [-C pcl_filtering] [-m menus] [-r]

Try '${FNAME} -h' for more information

EOT
exit 1
}

#-- usage_long text
usage_long()
{
FNAME=`${BASENAME_CMD} ${0}`
${CAT_CMD} << EOT

${FNAME}
    Sets up the application defaults.

USAGE:
    ${FNAME} -a asian_support -b browser -g group -p paper_size \\
                [-C pcl_filtering] [-m menus] [-r]
    ${FNAME} -h

OPTIONS:
     -a asian_support
        Enable Asian Driver support.
        Valid options are yes or no.

     -b browser
        Web Browser to access the User's Guild html files.
        Valid options are none or the absolute path to your web browser.
    
     -g group
        Administrative group
        Valid group is any standard UNIX group.
  
     -p paper_size
        Default paper size
        Valid paper sizes are letter or A4. 
        This option does not affect existing queues.

     -C pcl_filtering
        Enable PCL Emulation Job Filtering
        Valid options are enable or disable.

     -m menus
        Desktop Integration is specified by using tag=value separated by
        commas.  Valid tags are kde, gnome or cde.  Valid values are 
        install or remove.

        Example:  If you want to install our desktop entries in gnome and
                  kde, you would specify [ -m gnome=install,kde=install ].
        
     -r 
        Restart CUPS
        This option is only used with the -C option.
 
EOT
exit 1
}

setup_incomplete() 
{
	${ECHO_CMD}
	${ECHO_CMD} "Setup is incomplete. Please run the setup script again."
	${ECHO_CMD}
}

install_menu() 
{
	AVAILABLE_MENUS=`list_menus`
	menu=`${ECHO_CMD} ${menu} | ${SED_CMD} -e 's/,/\ /g'`

	${ECHO_CMD} ${AVAILABLE_MENUS} | ${GREP_CMD} "gnomeOnly" >/dev/null 2>&1
	if [ $? -eq 0 ];then
		GNOME_ONLY="YES"
	fi
	${ECHO_CMD} ${menu} | ${GREP_CMD} "gnome" >/dev/null 2>&1
	if [ $? -eq 0 ];then
		GNOME_FOUND="YES"
	fi

	#-- Check if the given desktop environment is installed.
	for d1 in ${menu}
	do
		d1="`${ECHO_CMD} ${d1} | ${TR_CMD} '[:upper:]' '[:lower:]'`"
		desktop=`${ECHO_CMD} ${d1} | ${SED_CMD} -e 's/=.*$//g'`
		option=`${ECHO_CMD} ${d1} | ${SED_CMD} -e 's/^.*=//g'`

		if [ "${GNOME_ONLY}" = "YES" -a "${desktop}" = "kde" -a "${GNOME_FOUND}" = "YES" ];then
			#-- Skip, gnome will catch it.
			continue
		elif [ "${GNOME_ONLY}" = "YES" -a "${desktop}" = "kde" ];then
			desktop="gnome"
		fi

		${ECHO_CMD} ${AVAILABLE_MENUS} | ${GREP_CMD} -i ${desktop} >/dev/null 2>&1
		if [ "${?}" != "0" ];then
			${ECHO_CMD} "Desktop environment ${desktop} is not installed."
			menu="`${ECHO_CMD} ${menu} | ${SED_CMD} -e "s/${d1}//"`"
		else
			case ${option} in
				'install') 
							${INSTALL_DIR}/bin/${desktop}_menu_utility.sh -i
							;;
				'remove' )
							${INSTALL_DIR}/bin/${desktop}_menu_utility.sh -r
							;;
						*   )
							${ECHO_CMD} "Menu option ${d1} is invalid."
							;;
			esac
		fi
	done
}

check_browser_file()
{
	browser="${1}"
	${ECHO_CMD} ${browser} | ${EGREP_CMD} -i "none" >/dev/null 2>&1
	if [ ${?} -eq 0 ];then
		return 0
	fi
	${ECHO_CMD} "${browser}" | ${EGREP_CMD} "^/" >/dev/null
	if [ ${?} -ne 0 ];then
		${ECHO_CMD} "Web Browser : Please enter the absolute path to your web broswer."
		return 2
	fi
	if [ ! -f "${browser}" ];then 
		${ECHO_CMD} "Web Browser : The file ${browser} does not exist."
		return 1
	elif [ -x "${browser}" ];then
		return 0
	else
		${ECHO_CMD} "Web Browser : The Web Browser provided is not executable."
		return 3
	fi
}



 
export DTUSERSESSION

INTERACTIVE="YES"
RESTART_CUPSD="NO"

while getopts A:a:B:b:C:G:g:hL:Mm:p:r  arg
do   
	case $arg in
		A) INTERACTIVE="NO"
			check_asian_queues "${OPTARG}"
			exit $?
			;;
		a) INTERACTIVE="NO"
			asian="${OPTARG}"
			if [ "${asian}" != "yes" -a "${asian}" != "no" ];then
      		${ECHO_CMD} "Invalid -a option [ ${asian} ].  Valid options are yes or no."
				exit 1
			fi
			;;
		B) INTERACTIVE="NO"
			browser="${OPTARG}"
			check_browser_file ${browser}
			exit ${?}
			;;	
		b) INTERACTIVE="NO"
			browser="${OPTARG}"
			check_browser_file ${browser}
			RC="${?}"
			if [ "${RC}" != "0" ];then
				exit ${RC}
			fi
			;;
		C)	INTERACTIVE="NO"
			CUPSD="${OPTARG}"
			cups="`${ECHO_CMD} ${OPTARG} | ${TR_CMD} '[:upper:]' '[:lower:]'`"
			if [ "${cups}" != "enable" -a "${cups}" != "disable" ];then
				${ECHO_CMD} "Invalid -C option [ ${OPTARG} ]. Valid options are enable or disable."
				exit 10 
			fi
			;;
		G)	INTERACTIVE="NO"
			check_group "${OPTARG}" 
			exit ${?}
			;;
		g) INTERACTIVE="NO"
			group="${OPTARG}"
			check_group "${group}" 
			if [ $? -ne 0 ];then
				exit 1
			fi
			;;
		h) INTERACTIVE="NO"
			usage_long
			;;
		L) INTERACTIVE="NO"
			case "${OPTARG}" in
				"BROWSER" ) list_browser       ; exit 0 ;;
				  "GROUP" ) list_default_group ; exit 0 ;;
			 "SUBSYSTEM" ) is_cups            ; exit ${?} ;;
						  * ) ${ECHO_CMD} "Invalid -L option [ ${OPTARG} ].  Valid options are BROWSER, GROUP, or SUBSYSTEM."
								exit 0 
								;;
			esac
			;;
		M) INTERACTIVE="NO"
			list_menus 
			exit 0;
			;;
		m) INTERACTIVE="NO"
			menu="${OPTARG}"
			;;
		p) INTERACTIVE="NO"
			paper="${OPTARG}"
			${ECHO_CMD} "${paper}" | ${EGREP_CMD} -i "LETTER|A4" >/dev/null 2>&1
			if [ $? -ne 0 ];then
				${ECHO_CMD} "Invalid -p option.  Valid options are letter or A4."
				exit 1
			fi
			;;
		r) INTERACTIVE="NO"
			RESTART_CUPSD="YES"
			;;
		*) usage_short
			;;
  esac
done

if [ "${INTERACTIVE}" = "NO" ];then
	if [ -z "${asian}"   ];then ${ECHO_CMD} "Missing -a option." ; MISS="yes" ;fi 
	if [ -z "${browser}" ];then ${ECHO_CMD} "Missing -b option." ; MISS="yes" ;fi 
	if [ -z "${group}"   ];then ${ECHO_CMD} "Missing -g option." ; MISS="yes" ;fi
	if [ -z "${paper}"   ];then ${ECHO_CMD} "Missing -p option." ; MISS="yes" ;fi 
	if [ "${MISS}" = "yes" ];then
		usage_short
	fi
	#-- Script begins here.
	${ECHO_CMD} "------------------------------------"
	${ECHO_CMD} "${PROGRAM_NAME} Setup Script"
	${ECHO_CMD} "------------------------------------"

   mk_spool_dirs
	set_group "${group}"
	set_browser2 "${browser}"
	set_paper_size2 "${paper}"
	set_enable_asian2 ${asian}
	install_menu "${menu}"

	set_print_subsystem
	linuxver
	set_install_date
	setup_done
else
	show_separator
	${ECHO_CMD} "${PROGRAM_NAME} Setup Script"
	show_separator
	mk_spool_dirs
	set_group
	show_separator
	set_browser
	show_separator
	set_paper_size
	show_separator
	set_enable_asian 
	kde_gnome_main
	show_separator
	set_print_subsystem
	linuxver
	set_install_date
	setup_done
fi
exit 0
 
