#!/bin/sh
#
#	Installation script for AIX 4.x colon files package
#

#
# Initialize variables
#


MSG_CAT_DIR="/usr/lib/lpd/pio/etc"
PREDEF_DIR="/usr/lib/lpd/pio/predef"
MSG_CAT_FILE="tsuu1.cat"
EULA_DIR="/usr/lib/lpd/pio/etc/euladoc"
EULA_FILE="toshiba_license.txt"

PREDEF_FILES="tsUniversal.pcl tsUniversal.ps tsUniversal.iq "

FILE_OWNER="root"
FILE_GROUP="printq"
COLON_PERMS="0664"
MSG_CAT_PERMS="0664"
EULA_PERMS="0444"
CHMOD="/usr/bin/chmod"
CHGRP="/usr/bin/chgrp"
CHOWN="/usr/bin/chown"
ECHO_CMD="/bin/echo"
EGREP_CMD="/bin/egrep"
GREP_CMD="/bin/grep"
SED_CMD="/bin/sed"

#
# confirm user input
#

confirm_user()
{
        rc=0
        if [ "$1" != "1" -a "${continue1}" = "yes" ];then
           rc=1
           return ${rc}
        fi
        if [ "$1" = "1" -a "${continue2}" = "yes" ];then
           ${ECHO_CMD} "    AUTOMATIC OVERWRITE"
           rc=1
           return ${rc}
        fi

        if [ "$1" = "1" ]; then
                ${ECHO_CMD} "        Continue .. (y/n/all/exit) [n]? \c"
        else
                ${ECHO_CMD} "    Continue .. (n/y/all/exit) [n]? \c"
        fi
        read answer
        if [ "$answer" = "y" -o "$answer" = "yes" ]; then
                rc=1
                return $rc
        elif [ "$answer" = "exit" -o  "$answer" = "e" ]; then
             exit 0
        elif [ "$answer" = "all" -o "$answer" = "a" ]; then
                if [ "$1" = "1" ];then
                   continue2=yes
                else
                   continue1=yes
                fi
                rc=1
                return $rc
        fi
        return $rc
}


#
# The Script starts here  ....
#

#
# Check for root
#

if [ `whoami` != 'root' ]
then
        ${ECHO_CMD}
        ${ECHO_CMD} "PERMISSION DENIED"
        ${ECHO_CMD}
        ${ECHO_CMD} "You must be root to run this program."
        ${ECHO_CMD}
        ${ECHO_CMD}
        exit 1
fi


#
# display notice/message/eula
#

clear

cat - << __END__
Toshiba Colon Files Installation Utility

=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
__END__

# for eula
if [ -f ${EULA_FILE} ]; then
    cat ${EULA_FILE}
    ${ECHO_CMD} "\n"
    ${ECHO_CMD} "Agree (y|n)? : [y] \c"

    read answer

    if [ "$answer" = "y" -o "$answer" = "yes" ]; then
        if [ ! -d $EULA_DIR ]; then
			mkdir $EULA_DIR
		fi 
		/bin/cp -f $EULA_FILE $EULA_DIR/$EULA_FILE
		$CHOWN $FILE_OWNER $EULA_DIR/$EULA_FILE
		$CHGRP $FILE_GROUP $EULA_DIR/$EULA_FILE
		$CHMOD $EULA_PERMS $EULA_DIR/$EULA_FILE
    else
        exit;
    fi
fi

cat - << __END__

This utility will install the AIX Colon files into the
system directories. It will also install the message
catalog to the default location.

You will be prompted to install every Colon file before
it is installed on the system.

__END__

${ECHO_CMD} "Press ENTER to continue ...\c"
read x
${ECHO_CMD}
${ECHO_CMD}


#
# Selecting Vendor
#
#if [ "TOSHIBA" == "GENERIC" ]; then


 #   MFT=""
 #   

	#Count OEM
#	mft_ctr=0
#	for tmp in ${MFT}
#	do 
#		mft_ctr=`expr ${mft_ctr} + 1`
#	done

	#Checks if OEM is greater than 1, if true displays the list of OEM.
#	if [ ${mft_ctr} -gt 1 ]; then

#		select_manufacturer="no"	
#		while [ "${select_manufacturer}" = "no" ]
#   		do
			
			#Displays the list of OEM to choose.
#			${ECHO_CMD} "Select the manufacturer of your printer:"
    
#   			cnt=0    
#  			for m in ${MFT}
# 			do
#				M=`${ECHO_CMD} ${m} | sed -e 'y/[abcdefghijklmnopqrstuvwxyz]/[ABCDEFGHIJKLMNOPQRSTUVWXYZ]/'` 
#				cnt=`expr $cnt + 1`

#				if [ "${M}" == "IPS" ]; then
					
#					M="InfoPrint Solutions Co."
		
#				fi
		
#				${ECHO_CMD} "${cnt} ${M}"
#	    		done
			
			
#   			${ECHO_CMD} "Continue .. (1..${cnt}) [1]?\c"
#  			read answer
	
			#Checks if blank or default was selected	
#			${ECHO_CMD} "${answer}" | ${EGREP_CMD} "  *" >/dev/null 2>&1
#     			if [ "${?}" = "0" ] || [ -z "${answer}" ];then
#      			   answer=1
#      			fi
	
			
			#Checks if entered value is a number
#			${ECHO_CMD} "${answer}" | ${EGREP_CMD} "^[0-9][0-9]*$" >/dev/null 2>&1
#			if [ "${?}" != "0" ];then
#				${ECHO_CMD}
#        			${ECHO_CMD} "Invalid Selection! "
#				${ECHO_CMD}
#        			continue
#       		fi
	
			#Checks if entered value is on the range of the list.
#			if [ ${answer} -lt 1 -o ${answer} -gt ${cnt} ]; then
#				${ECHO_CMD}
#				${ECHO_CMD} "Invalid Selection! "
#				${ECHO_CMD}
#				continue
#			fi

			#Sets the flag to exit the loop on the next time.
#			select_manufacturer="yes"	

			#Assign the selected OEM to manufacturer
#			eval manufacturer=$`${ECHO_CMD} mft_${answer}`
			
			#Modify the list of PREDEF_FILES, removed the unselected files and assign it to PREDEF_HOLD.
#			PREDEF_HOLDER=""
#			for file in `${ECHO_CMD} ${PREDEF_FILES}`
#			do
#				${ECHO_CMD} ${file} | ${GREP_CMD} ${manufacturer} >/dev/null 2>&1
#				if [ $? -eq 0 ]; then
#					PREDEF_HOLDER="${PREDEF_HOLDER} ${file}"
#				fi
#			done

			#Assign the new set of files back to PREDEF_FILES
#			PREDEF_FILES=`${ECHO_CMD} ${PREDEF_HOLDER} | ${SED_CMD} -e "s/^ //g"`

#		done

#	fi
#fi


#
# Install the colon files
#

#MVPRINTPACKAGE

rc=0


for i in $PREDEF_FILES
do
	file_name=`grep ":mL:" $i| sed -e 's/.*:://g'`
	${ECHO_CMD} "Installing [ $file_name ($i) ] ..."
	confirm_user 
	if [ "$rc" = "1" ]
	then
		if [ -f "$PREDEF_DIR/$i" ]
		then
			${ECHO_CMD} "    WARNING:"
			${ECHO_CMD} "       This printer already exists on your system .."
			confirm_user 1 
			if [ "$rc" = "1" ]
			then
				${ECHO_CMD} "    installing $i ... \c"
				cp $i $PREDEF_DIR/$i
				$CHOWN $FILE_OWNER $PREDEF_DIR/$i
				$CHGRP $FILE_GROUP $PREDEF_DIR/$i
				$CHMOD $COLON_PERMS $PREDEF_DIR/$i
				${ECHO_CMD} "done"
			else
				${ECHO_CMD} "Skipped at user request."
			fi
		else
			${ECHO_CMD} "    installing $i ... \c"
			cp $i $PREDEF_DIR/$i
			$CHOWN $FILE_OWNER $PREDEF_DIR/$i
			$CHGRP $FILE_GROUP $PREDEF_DIR/$i
			$CHMOD $COLON_PERMS $PREDEF_DIR/$i
			${ECHO_CMD} "done"
		fi
	else
		${ECHO_CMD} "    Skipped at user request."
	fi
	${ECHO_CMD}
done

#
# install the message catalog
#

${ECHO_CMD} "Installing [ $MSG_CAT_FILE ] ..."
confirm_user
if [ "$rc" = "1" ]
then
	if [ -f "$MSG_CAT_DIR/$MSG_CAT_FILE" ]
	then
		${ECHO_CMD} "    WARNING:"
		${ECHO_CMD} "       This message catalog already exists on your system .."
		confirm_user 1
		if [ "$rc" = "1" ]
		then
			${ECHO_CMD} "    installing $MSG_CAT_FILE ...\c"
			cp $MSG_CAT_FILE $MSG_CAT_DIR/$MSG_CAT_FILE
			$CHOWN $FILE_OWNER $MSG_CAT_DIR/$MSG_CAT_FILE
			$CHGRP $FILE_GROUP $MSG_CAT_DIR/$MSG_CAT_FILE
			$CHMOD $MSG_CAT_PERMS $MSG_CAT_DIR/$MSG_CAT_FILE
			${ECHO_CMD} "Done."
		else
			${ECHO_CMD} "    Skipped at user request."
		fi
	else
		${ECHO_CMD} "    installing $MSG_CAT_FILE ...\c"
		cp $MSG_CAT_FILE $MSG_CAT_DIR/$MSG_CAT_FILE
		$CHOWN $FILE_OWNER $MSG_CAT_DIR/$MSG_CAT_FILE
		$CHGRP $FILE_GROUP $MSG_CAT_DIR/$MSG_CAT_FILE
		$CHMOD $MSG_CAT_PERMS $MSG_CAT_DIR/$MSG_CAT_FILE
		${ECHO_CMD} "Done."
	fi
else
		${ECHO_CMD} "    Skipped at user request."
fi

${ECHO_CMD}
${ECHO_CMD} "Installation complete."
${ECHO_CMD}
exit
